/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;

@Immutable
abstract class AbstractJsonFieldDefinition<T>
implements JsonFieldDefinition<T> {
    private final JsonPointer pointer;
    private final Class<T> valueType;
    private final Function<JsonValue, Boolean> checkJavaTypeFunction;
    private final Function<JsonValue, T> mappingFunction;
    private final Set<JsonFieldMarker> markers;

    protected AbstractJsonFieldDefinition(CharSequence pointer, Class<T> valueType, Function<JsonValue, Boolean> checkJavaTypeFunction, Function<JsonValue, T> mappingFunction, JsonFieldMarker ... markers) {
        Objects.requireNonNull(pointer, "The JSON pointer of the field definition must not be null!");
        Objects.requireNonNull(markers, "The markers must not be null!");
        this.pointer = JsonFactory.newPointer(pointer);
        this.valueType = Objects.requireNonNull(valueType, "The value type of the field definition must not be null!");
        this.checkJavaTypeFunction = Objects.requireNonNull(checkJavaTypeFunction, "The Java type checking function must not be null!");
        this.mappingFunction = Objects.requireNonNull(mappingFunction, "The mapping function must not be null!");
        HashSet mutableMarkersSet = new HashSet(markers.length);
        Collections.addAll(mutableMarkersSet, markers);
        this.markers = Collections.unmodifiableSet(mutableMarkersSet);
    }

    @Override
    public JsonPointer getPointer() {
        return this.pointer;
    }

    @Override
    public Class<T> getValueType() {
        return this.valueType;
    }

    @Override
    public Set<JsonFieldMarker> getMarkers() {
        return this.markers;
    }

    @Override
    public boolean isMarkedAs(JsonFieldMarker fieldMarker, JsonFieldMarker ... furtherFieldMarkers) {
        Objects.requireNonNull(fieldMarker, "At least one marker has to be specified!");
        Objects.requireNonNull(furtherFieldMarkers, "The further field markers must not be null!");
        HashSet<JsonFieldMarker> askedMarkers = new HashSet<JsonFieldMarker>(1 + furtherFieldMarkers.length);
        askedMarkers.add(fieldMarker);
        Collections.addAll(askedMarkers, furtherFieldMarkers);
        return this.markers.containsAll(askedMarkers);
    }

    @Override
    @Nullable
    public T mapValue(JsonValue jsonValue) {
        this.checkValueType(jsonValue);
        return this.getAsJavaType(jsonValue, this.mappingFunction);
    }

    private void checkValueType(JsonValue jsonValue) {
        Objects.requireNonNull(jsonValue, "The JsonValue to be mapped must not be (Java) null!");
        if (!this.hasExpectedValueType(jsonValue)) {
            String msgPattern = "Value <{0}> for <{1}> is not of type <{2}>!";
            String message = MessageFormat.format("Value <{0}> for <{1}> is not of type <{2}>!", jsonValue, this.pointer, this.valueType.getSimpleName());
            throw new JsonParseException(message);
        }
    }

    private boolean hasExpectedValueType(JsonValue jsonValue) {
        return jsonValue.isNull() || this.checkJavaTypeFunction.apply(jsonValue) != false;
    }

    @Nullable
    protected abstract T getAsJavaType(JsonValue var1, Function<JsonValue, T> var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractJsonFieldDefinition that = (AbstractJsonFieldDefinition)o;
        return Objects.equals(this.pointer, that.pointer) && Objects.equals(this.valueType, that.valueType) && Objects.equals(this.checkJavaTypeFunction, that.checkJavaTypeFunction) && Objects.equals(this.mappingFunction, that.mappingFunction) && Objects.equals(this.markers, that.markers);
    }

    public int hashCode() {
        return Objects.hash(this.pointer, this.valueType, this.checkJavaTypeFunction, this.mappingFunction, this.markers);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [pointer=" + this.pointer + ", valueType=" + this.valueType + ", checkJavaTypeFunction=" + this.checkJavaTypeFunction + ", mappingFunction=" + this.mappingFunction + ", markers=" + this.markers + "]";
    }
}

