/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;

abstract class AbstractJsonMerger {
    AbstractJsonMerger() {
    }

    protected static boolean areJsonObjects(JsonValue value1, JsonValue value2) {
        return value1.isObject() && value2.isObject();
    }

    protected static boolean areJsonArrays(JsonValue value1, JsonValue value2) {
        return value1.isArray() && value2.isArray();
    }

    protected static JsonObject filterNullValues(JsonObject jsonObject) {
        JsonObjectBuilder builder = JsonFactory.newObjectBuilder();
        jsonObject.forEach(jsonField -> {
            JsonKey key = jsonField.getKey();
            JsonValue value = jsonField.getValue();
            if (value.isNull()) {
                return;
            }
            JsonValue result = value.isObject() ? AbstractJsonMerger.filterNullValues(value.asObject()) : value;
            builder.set((CharSequence)key, result);
        });
        return builder.build();
    }
}

