/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Objects;
import org.eclipse.ditto.json.AbstractJsonValue;
import org.eclipse.ditto.json.JsonNumber;

abstract class AbstractJsonNumber<T extends Number>
extends AbstractJsonValue
implements JsonNumber {
    private final T value;

    protected AbstractJsonNumber(T value) {
        this.value = (Number)Objects.requireNonNull(value, "The value must not be null!");
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public int asInt() {
        if (this.isInt()) {
            return ((Number)this.value).intValue();
        }
        throw new NumberFormatException("This JSON value is not an int: " + this.value);
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public long asLong() {
        if (this.isLong()) {
            return ((Number)this.value).longValue();
        }
        throw new NumberFormatException("This JSON value is not a long: " + this.value);
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double asDouble() {
        return ((Number)this.value).doubleValue();
    }

    T getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }
}

