/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.DittoJsonHandler;
import org.eclipse.ditto.json.ImmutableJsonArray;
import org.eclipse.ditto.json.ImmutableJsonBoolean;
import org.eclipse.ditto.json.ImmutableJsonDouble;
import org.eclipse.ditto.json.ImmutableJsonInt;
import org.eclipse.ditto.json.ImmutableJsonLong;
import org.eclipse.ditto.json.ImmutableJsonNull;
import org.eclipse.ditto.json.ImmutableJsonObject;
import org.eclipse.ditto.json.ImmutableJsonString;
import org.eclipse.ditto.json.JavaStringToEscapedJsonString;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonNumber;
import org.eclipse.ditto.json.JsonValue;

@NotThreadSafe
final class DefaultDittoJsonHandler
extends DittoJsonHandler<List<JsonValue>, List<JsonField>, JsonValue> {
    private static final int DEFAULT_INITIAL_STRING_BUILDER_CAPACITY = 512;
    private static final char DELIMITER = ',';
    private final Deque<StringBuilder> stringBuilders = new ArrayDeque<StringBuilder>();
    private String valueString = null;
    private JsonValue jsonValue = null;

    private DefaultDittoJsonHandler() {
    }

    public static DefaultDittoJsonHandler newInstance() {
        return new DefaultDittoJsonHandler();
    }

    public List<JsonValue> startArray() {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append('[');
        this.stringBuilders.push(stringBuilder);
        return new ArrayList<JsonValue>();
    }

    public List<JsonField> startObject() {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append('{');
        this.stringBuilders.push(stringBuilder);
        return new ArrayList<JsonField>();
    }

    public void endNull() {
        this.jsonValue = ImmutableJsonNull.getInstance();
        this.valueString = "null";
    }

    public void endBoolean(boolean value) {
        this.jsonValue = value ? ImmutableJsonBoolean.TRUE : ImmutableJsonBoolean.FALSE;
        this.valueString = String.valueOf(value);
    }

    public void endString(String string) {
        this.jsonValue = ImmutableJsonString.of(string);
        this.valueString = DefaultDittoJsonHandler.getEscapedJsonString(string);
    }

    private static String getEscapedJsonString(String javaString) {
        JavaStringToEscapedJsonString javaStringToEscapeJsonString = JavaStringToEscapedJsonString.getInstance();
        return (String)javaStringToEscapeJsonString.apply(javaString);
    }

    public void endNumber(String string) {
        this.jsonValue = DefaultDittoJsonHandler.getNumberFor(string);
        this.valueString = string;
    }

    private static JsonNumber getNumberFor(String string) {
        if (DefaultDittoJsonHandler.isDecimal(string)) {
            return DefaultDittoJsonHandler.parseToDouble(string);
        }
        return DefaultDittoJsonHandler.parseToIntegerOrLong(string);
    }

    private static boolean isDecimal(String string) {
        for (char c : string.toCharArray()) {
            if ('.' != c && 'e' != c && 'E' != c) continue;
            return true;
        }
        return false;
    }

    private static ImmutableJsonDouble parseToDouble(String string) {
        return ImmutableJsonDouble.of(Double.parseDouble(string));
    }

    private static JsonNumber parseToIntegerOrLong(String string) {
        try {
            return DefaultDittoJsonHandler.parseToInteger(string);
        }
        catch (NumberFormatException e) {
            return DefaultDittoJsonHandler.parseToLong(string);
        }
    }

    private static ImmutableJsonInt parseToInteger(String string) {
        return ImmutableJsonInt.of(Integer.parseInt(string));
    }

    private static ImmutableJsonLong parseToLong(String string) {
        return ImmutableJsonLong.of(Long.parseLong(string));
    }

    public void endArrayValue(List<JsonValue> jsonValues) {
        jsonValues.add(this.jsonValue);
        StringBuilder stringBuilder = this.stringBuilders.peek();
        if (null != stringBuilder) {
            stringBuilder.append(this.valueString);
            stringBuilder.append(',');
        }
    }

    public void endArray(List<JsonValue> jsonValues) {
        StringBuilder stringBuilder = this.stringBuilders.poll();
        if (null != stringBuilder) {
            if (!jsonValues.isEmpty()) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            stringBuilder.append(']');
            this.valueString = stringBuilder.toString();
        }
        this.jsonValue = ImmutableJsonArray.of(jsonValues, this.valueString);
    }

    public void endObjectValue(List<JsonField> jsonFields, String name) {
        JsonField jsonField = JsonField.newInstance(name, this.jsonValue);
        jsonFields.add(jsonField);
        StringBuilder stringBuilder = this.stringBuilders.peek();
        if (null != stringBuilder) {
            stringBuilder.append(DefaultDittoJsonHandler.getEscapedJsonString(name));
            stringBuilder.append(':');
            stringBuilder.append(this.valueString);
            stringBuilder.append(',');
        }
    }

    public void endObject(List<JsonField> jsonFields) {
        StringBuilder stringBuilder = this.stringBuilders.poll();
        if (null != stringBuilder) {
            if (!jsonFields.isEmpty()) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            stringBuilder.append('}');
            this.valueString = stringBuilder.toString();
        }
        LinkedHashMap<String, JsonField> fieldMap = new LinkedHashMap<String, JsonField>(jsonFields.size());
        for (JsonField jsonField : jsonFields) {
            fieldMap.put(jsonField.getKeyName(), jsonField);
        }
        this.jsonValue = ImmutableJsonObject.of(fieldMap, this.valueString);
    }

    @Override
    protected JsonValue getValue() {
        return this.jsonValue;
    }
}

