/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.AbstractJsonValue;
import org.eclipse.ditto.json.CborFactory;
import org.eclipse.ditto.json.DefaultDittoJsonHandler;
import org.eclipse.ditto.json.DittoJsonHandler;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.JsonValueParser;
import org.eclipse.ditto.json.NoopCborFactory;
import org.eclipse.ditto.json.SerializationContext;

@Immutable
final class ImmutableJsonArray
extends AbstractJsonValue
implements JsonArray {
    @Nullable
    private static ImmutableJsonArray emptyInstance = null;
    private static final String ASSERTION_VALUES_OF_JSON_ARRAY = "The values of the JSON array must not be null!";
    private final SoftReferencedValueList valueList;

    ImmutableJsonArray(SoftReferencedValueList theValueList) {
        this.valueList = theValueList;
    }

    public static ImmutableJsonArray empty() {
        ImmutableJsonArray result = emptyInstance;
        if (null == result) {
            emptyInstance = result = new ImmutableJsonArray(SoftReferencedValueList.empty());
        }
        return result;
    }

    public static ImmutableJsonArray of(List<JsonValue> values) {
        return new ImmutableJsonArray(SoftReferencedValueList.of(values));
    }

    public static ImmutableJsonArray of(List<JsonValue> values, @Nullable String stringRepresentation) {
        Objects.requireNonNull(values, ASSERTION_VALUES_OF_JSON_ARRAY);
        return new ImmutableJsonArray(SoftReferencedValueList.of(values, stringRepresentation));
    }

    public static ImmutableJsonArray of(List<JsonValue> values, @Nullable byte[] cborRepresentation) {
        Objects.requireNonNull(values, ASSERTION_VALUES_OF_JSON_ARRAY);
        return new ImmutableJsonArray(SoftReferencedValueList.of(values, cborRepresentation));
    }

    public static ImmutableJsonArray of(List<JsonValue> values, @Nullable String stringRepresentation, @Nullable byte[] cborRepresentation) {
        Objects.requireNonNull(values, ASSERTION_VALUES_OF_JSON_ARRAY);
        return new ImmutableJsonArray(SoftReferencedValueList.of(values, stringRepresentation, cborRepresentation));
    }

    private static void checkValue(Object value) {
        Objects.requireNonNull(value, "The value to add must not be null!");
    }

    private static void checkFurtherValues(Object furtherValues) {
        Objects.requireNonNull(furtherValues, "The further values must not be null! If none are required just omit this argument.");
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public ImmutableJsonArray asArray() {
        return this;
    }

    @Override
    public ImmutableJsonArray add(int value, int ... furtherValues) {
        ImmutableJsonArray.checkFurtherValues(furtherValues);
        return this.add(JsonValue.of(value), (JsonValue[])Arrays.stream(furtherValues).mapToObj(JsonValue::of).toArray(JsonValue[]::new));
    }

    @Override
    public ImmutableJsonArray add(long value, long ... furtherValues) {
        ImmutableJsonArray.checkFurtherValues(furtherValues);
        return this.add(JsonValue.of(value), (JsonValue[])Arrays.stream(furtherValues).mapToObj(JsonValue::of).toArray(JsonValue[]::new));
    }

    @Override
    public ImmutableJsonArray add(double value, double ... furtherValues) {
        ImmutableJsonArray.checkFurtherValues(furtherValues);
        return this.add(JsonValue.of(value), (JsonValue[])Arrays.stream(furtherValues).mapToObj(JsonValue::of).toArray(JsonValue[]::new));
    }

    @Override
    public ImmutableJsonArray add(boolean value, boolean ... furtherValues) {
        ImmutableJsonArray.checkFurtherValues(furtherValues);
        SoftReferencedValueList extendedValueList = this.valueList.add(JsonValue.of(value));
        for (boolean furtherValue : furtherValues) {
            extendedValueList = extendedValueList.add(JsonValue.of(furtherValue));
        }
        return new ImmutableJsonArray(extendedValueList);
    }

    @Override
    public ImmutableJsonArray add(String value, String ... furtherValues) {
        ImmutableJsonArray.checkValue(value);
        ImmutableJsonArray.checkFurtherValues(furtherValues);
        return this.add(JsonValue.of(value), (JsonValue[])Arrays.stream(furtherValues).map(JsonValue::of).toArray(JsonValue[]::new));
    }

    @Override
    public ImmutableJsonArray add(JsonValue value, JsonValue ... furtherValues) {
        ImmutableJsonArray.checkValue(value);
        ImmutableJsonArray.checkFurtherValues(furtherValues);
        SoftReferencedValueList extendedValueList = this.valueList.add(value);
        for (JsonValue furtherValue : furtherValues) {
            extendedValueList = extendedValueList.add(furtherValue);
        }
        return new ImmutableJsonArray(extendedValueList);
    }

    @Override
    public Optional<JsonValue> get(int index) {
        try {
            return Optional.of(this.valueList.get(index));
        }
        catch (IndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.valueList.isEmpty();
    }

    @Override
    public int getSize() {
        return this.valueList.getSize();
    }

    @Override
    public boolean contains(JsonValue value) {
        Objects.requireNonNull(value, "The value whose presence in this array is to be tested must not be null!");
        return this.valueList.contains(value);
    }

    @Override
    public int indexOf(JsonValue value) {
        Objects.requireNonNull(value, "The value to search the index for must not be null!");
        return this.valueList.indexOf(value);
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return this.valueList.getIterator();
    }

    @Override
    public Stream<JsonValue> stream() {
        return this.valueList.getStream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonArray that = (ImmutableJsonArray)o;
        return Objects.equals(this.valueList, that.valueList);
    }

    public int hashCode() {
        return this.valueList.hashCode();
    }

    @Override
    public String toString() {
        return this.valueList.asJsonArrayString();
    }

    @Override
    public void writeValue(SerializationContext serializationContext) throws IOException {
        this.valueList.writeValue(serializationContext);
    }

    @Override
    public long getUpperBoundForStringSize() {
        return this.valueList.upperBoundForStringSize();
    }

    @NotThreadSafe
    static final class ValueListJsonHandler
    extends DittoJsonHandler<List<JsonValue>, List<JsonField>, List<JsonValue>> {
        private final DefaultDittoJsonHandler defaultHandler = DefaultDittoJsonHandler.newInstance();
        private List<JsonValue> value = null;
        private final Deque<List<JsonValue>> jsonArrayBuilders = new ArrayDeque<List<JsonValue>>();
        private int level = 0;

        ValueListJsonHandler() {
        }

        public List<JsonValue> startArray() {
            if (0 < this.level) {
                this.jsonArrayBuilders.push((List<JsonValue>)this.defaultHandler.startArray());
            }
            ArrayList<JsonValue> result = new ArrayList<JsonValue>();
            ++this.level;
            return result;
        }

        public List<JsonField> startObject() {
            return this.defaultHandler.startObject();
        }

        public void endNull() {
            this.defaultHandler.endNull();
        }

        public void endBoolean(boolean value) {
            this.defaultHandler.endBoolean(value);
        }

        public void endString(String string) {
            this.defaultHandler.endString(string);
        }

        public void endNumber(String string) {
            this.defaultHandler.endNumber(string);
        }

        public void endArrayValue(List<JsonValue> jsonValues) {
            List<JsonValue> jsonArrayBuilder = this.jsonArrayBuilders.peek();
            if (null != jsonArrayBuilder) {
                this.defaultHandler.endArrayValue(jsonArrayBuilder);
            } else {
                jsonValues.add(this.defaultHandler.getValue());
            }
        }

        public void endArray(List<JsonValue> jsonValues) {
            List<JsonValue> jsonArrayBuilder = this.jsonArrayBuilders.poll();
            if (null != jsonArrayBuilder) {
                this.defaultHandler.endArray(jsonArrayBuilder);
            } else {
                this.value = new ArrayList<JsonValue>(jsonValues);
            }
            --this.level;
        }

        public void endObject(List<JsonField> jsonFields) {
            this.defaultHandler.endObject(jsonFields);
        }

        public void endObjectValue(List<JsonField> jsonFields, String name) {
            this.defaultHandler.endObjectValue(jsonFields, name);
        }

        @Override
        protected List<JsonValue> getValue() {
            return this.value;
        }
    }

    @Immutable
    static final class SoftReferencedValueList {
        private static final long CBOR_MAX_COMPRESSION_RATIO = 5L;
        private static final CborFactory CBOR_FACTORY;
        private String jsonArrayStringRepresentation;
        private byte[] cborArrayRepresentation;
        private int hashCode;
        private SoftReference<List<JsonValue>> valuesReference;

        private SoftReferencedValueList(List<JsonValue> jsonValueList, @Nullable String stringRepresentation, @Nullable byte[] cborArrayRepresentation) {
            this.valuesReference = new SoftReference<List<JsonValue>>(Collections.unmodifiableList(new ArrayList<JsonValue>(jsonValueList)));
            this.jsonArrayStringRepresentation = stringRepresentation;
            this.cborArrayRepresentation = cborArrayRepresentation;
            if (this.jsonArrayStringRepresentation == null && cborArrayRepresentation == null) {
                if (CBOR_FACTORY.isCborAvailable()) {
                    try {
                        this.cborArrayRepresentation = CBOR_FACTORY.createCborRepresentation(jsonValueList, this.guessSerializedSize());
                    }
                    catch (IOException e) {
                        assert (false);
                        this.jsonArrayStringRepresentation = this.createStringRepresentation(jsonValueList);
                    }
                } else {
                    this.jsonArrayStringRepresentation = this.createStringRepresentation(jsonValueList);
                }
            }
            this.hashCode = 0;
        }

        static SoftReferencedValueList empty() {
            return SoftReferencedValueList.of(Collections.emptyList(), "[]", new byte[]{-128});
        }

        static SoftReferencedValueList of(List<JsonValue> values) {
            return new SoftReferencedValueList(values, null, null);
        }

        static SoftReferencedValueList of(List<JsonValue> jsonValueList, @Nullable String stringRepresentation) {
            return new SoftReferencedValueList(jsonValueList, stringRepresentation, null);
        }

        static SoftReferencedValueList of(List<JsonValue> jsonValueList, @Nullable byte[] cborRepresentation) {
            return new SoftReferencedValueList(jsonValueList, null, cborRepresentation);
        }

        static SoftReferencedValueList of(List<JsonValue> jsonValueList, @Nullable String stringRepresentation, @Nullable byte[] cborRepresentation) {
            return new SoftReferencedValueList(jsonValueList, stringRepresentation, cborRepresentation);
        }

        private String createStringRepresentation(Iterable<JsonValue> jsonValues) {
            StringBuilder stringBuilder = new StringBuilder(this.guessSerializedSize());
            stringBuilder.append('[');
            String delimiter = "";
            for (JsonValue jsonValue : jsonValues) {
                stringBuilder.append(delimiter);
                stringBuilder.append(jsonValue);
                delimiter = ",";
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        JsonValue get(int index) {
            return this.values().get(index);
        }

        boolean isEmpty() {
            return this.values().isEmpty();
        }

        int getSize() {
            return this.values().size();
        }

        boolean contains(JsonValue value) {
            return this.values().contains(value);
        }

        int indexOf(JsonValue value) {
            return this.values().indexOf(value);
        }

        SoftReferencedValueList add(JsonValue jsonValue) {
            List<JsonValue> valuesCopy = this.copyValues();
            valuesCopy.add(jsonValue);
            return SoftReferencedValueList.of(valuesCopy);
        }

        private List<JsonValue> copyValues() {
            return new ArrayList<JsonValue>(this.values());
        }

        private List<JsonValue> values() {
            List<JsonValue> result = this.valuesReference.get();
            if (null == result) {
                result = this.recoverValues();
                this.valuesReference = new SoftReference<List<JsonValue>>(result);
            }
            return result;
        }

        private List<JsonValue> recoverValues() {
            if (CBOR_FACTORY.isCborAvailable() && this.cborArrayRepresentation != null) {
                return SoftReferencedValueList.parseToList(this.cborArrayRepresentation);
            }
            if (this.jsonArrayStringRepresentation != null) {
                return SoftReferencedValueList.parseToList(this.jsonArrayStringRepresentation);
            }
            throw new IllegalStateException("Fatal cache miss on JsonObject");
        }

        private static List<JsonValue> parseToList(String jsonArrayString) {
            ValueListJsonHandler jsonHandler = new ValueListJsonHandler();
            JsonValueParser.fromString(jsonHandler).accept(jsonArrayString);
            return jsonHandler.getValue();
        }

        private static List<JsonValue> parseToList(byte[] cborArrayRepresentation) {
            JsonValue jsonArray = CBOR_FACTORY.readFrom(cborArrayRepresentation);
            LinkedList<JsonValue> list = new LinkedList<JsonValue>();
            for (JsonValue jsonValue : jsonArray.asArray()) {
                list.add(jsonValue);
            }
            return list;
        }

        Iterator<JsonValue> getIterator() {
            return this.values().iterator();
        }

        Stream<JsonValue> getStream() {
            return this.values().stream();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SoftReferencedValueList that = (SoftReferencedValueList)o;
            if (this.jsonArrayStringRepresentation != null && that.jsonArrayStringRepresentation != null) {
                if (this.jsonArrayStringRepresentation.equals(that.jsonArrayStringRepresentation)) {
                    return true;
                }
                if (this.jsonArrayStringRepresentation.length() == that.jsonArrayStringRepresentation.length()) {
                    return Objects.equals(this.values(), that.values());
                }
                return false;
            }
            if (this.cborArrayRepresentation != null && that.cborArrayRepresentation != null && Arrays.equals(this.cborArrayRepresentation, that.cborArrayRepresentation)) {
                return true;
            }
            return Objects.equals(this.values(), that.values());
        }

        public int hashCode() {
            int result = this.hashCode;
            if (0 == result) {
                this.hashCode = result = this.values().hashCode();
            }
            return result;
        }

        String asJsonArrayString() {
            if (this.jsonArrayStringRepresentation == null) {
                this.jsonArrayStringRepresentation = this.createStringRepresentation(this.values());
            }
            return this.jsonArrayStringRepresentation;
        }

        void writeValue(SerializationContext serializationContext) throws IOException {
            if (CBOR_FACTORY.isCborAvailable() && this.cborArrayRepresentation == null) {
                this.cborArrayRepresentation = CBOR_FACTORY.createCborRepresentation(this.values(), this.guessSerializedSize());
            }
            serializationContext.writeCachedElement(this.cborArrayRepresentation);
        }

        private int guessSerializedSize() {
            if (this.jsonArrayStringRepresentation != null) {
                return this.jsonArrayStringRepresentation.length();
            }
            if (this.cborArrayRepresentation != null) {
                return this.cborArrayRepresentation.length;
            }
            return 512;
        }

        public long upperBoundForStringSize() {
            if (this.jsonArrayStringRepresentation != null) {
                return this.jsonArrayStringRepresentation.length();
            }
            if (this.cborArrayRepresentation != null) {
                return (long)this.cborArrayRepresentation.length * 5L;
            }
            assert (false);
            return Long.MAX_VALUE;
        }

        static {
            ServiceLoader<CborFactory> sl = ServiceLoader.load(CborFactory.class);
            CBOR_FACTORY = StreamSupport.stream(sl.spliterator(), false).findFirst().orElseGet(NoopCborFactory::new);
        }
    }
}

