/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.ImmutableJsonArray;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonArrayBuilder;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonValue;

@NotThreadSafe
final class ImmutableJsonArrayBuilder
implements JsonArrayBuilder {
    private final List<JsonValue> values = new ArrayList<JsonValue>();

    private ImmutableJsonArrayBuilder() {
    }

    public static ImmutableJsonArrayBuilder newInstance() {
        return new ImmutableJsonArrayBuilder();
    }

    private static void checkValue(Object value) {
        Objects.requireNonNull(value, "The value to be added must not be null!");
    }

    private static void checkFurtherValues(Object furtherValues) {
        Objects.requireNonNull(furtherValues, "The further values to be added must not be null! If none are required just omit this argument.");
    }

    @Override
    public ImmutableJsonArrayBuilder add(int value, int ... furtherValues) {
        ImmutableJsonArrayBuilder.checkFurtherValues(furtherValues);
        this.values.add(JsonFactory.newValue(value));
        this.addAll(Arrays.stream(furtherValues).mapToObj(JsonFactory::newValue));
        return this;
    }

    private void addAll(Stream<JsonValue> jsonValueStream) {
        jsonValueStream.forEach(this.values::add);
    }

    @Override
    public ImmutableJsonArrayBuilder addIntegers(Iterable<Integer> intValues) {
        return this.addAll((Iterable)ImmutableJsonArrayBuilder.getStream(Objects.requireNonNull(intValues, "The int values to be added must not be null!")).map(JsonFactory::newValue).collect(Collectors.toList()));
    }

    @Override
    public JsonArrayBuilder set(int index, int value) {
        return this.set(index, JsonFactory.newValue(value));
    }

    @Override
    public ImmutableJsonArrayBuilder add(long value, long ... furtherValues) {
        ImmutableJsonArrayBuilder.checkFurtherValues(furtherValues);
        this.values.add(JsonFactory.newValue(value));
        this.addAll(Arrays.stream(furtherValues).mapToObj(JsonFactory::newValue));
        return this;
    }

    @Override
    public ImmutableJsonArrayBuilder addLongs(Iterable<Long> longValues) {
        return this.addAll((Iterable)ImmutableJsonArrayBuilder.getStream(Objects.requireNonNull(longValues, "The long values to be added must not be null!")).map(JsonFactory::newValue).collect(Collectors.toList()));
    }

    @Override
    public JsonArrayBuilder set(int index, long value) {
        return this.set(index, JsonFactory.newValue(value));
    }

    @Override
    public ImmutableJsonArrayBuilder add(double value, double ... furtherValues) {
        ImmutableJsonArrayBuilder.checkFurtherValues(furtherValues);
        this.values.add(JsonFactory.newValue(value));
        this.addAll(Arrays.stream(furtherValues).mapToObj(JsonFactory::newValue));
        return this;
    }

    @Override
    public ImmutableJsonArrayBuilder addDoubles(Iterable<Double> doubleValues) {
        return this.addAll((Iterable)ImmutableJsonArrayBuilder.getStream(Objects.requireNonNull(doubleValues, "The double values to be added must not be null!")).map(JsonFactory::newValue).collect(Collectors.toList()));
    }

    @Override
    public JsonArrayBuilder set(int index, double value) {
        return this.set(index, JsonFactory.newValue(value));
    }

    @Override
    public ImmutableJsonArrayBuilder add(boolean value, boolean ... furtherValues) {
        ImmutableJsonArrayBuilder.checkFurtherValues(furtherValues);
        this.values.add(JsonFactory.newValue(value));
        for (boolean furtherValue : furtherValues) {
            this.values.add(JsonFactory.newValue(furtherValue));
        }
        return this;
    }

    @Override
    public ImmutableJsonArrayBuilder addBooleans(Iterable<Boolean> booleanValues) {
        return this.addAll((Iterable)ImmutableJsonArrayBuilder.getStream(Objects.requireNonNull(booleanValues, "The boolean values to be added must not be null!")).map(JsonFactory::newValue).collect(Collectors.toList()));
    }

    @Override
    public JsonArrayBuilder set(int index, boolean value) {
        return this.set(index, JsonFactory.newValue(value));
    }

    @Override
    public ImmutableJsonArrayBuilder add(String value, String ... furtherValues) {
        ImmutableJsonArrayBuilder.checkValue(value);
        ImmutableJsonArrayBuilder.checkFurtherValues(furtherValues);
        ArrayList<String> allStringValues = new ArrayList<String>(1 + furtherValues.length);
        allStringValues.add(value);
        Collections.addAll(allStringValues, furtherValues);
        return this.addStrings(allStringValues);
    }

    @Override
    public ImmutableJsonArrayBuilder addStrings(Iterable<String> stringValues) {
        return this.addAll((Iterable)ImmutableJsonArrayBuilder.getStream(Objects.requireNonNull(stringValues, "The String values to be added must not be null!")).map(JsonFactory::newValue).collect(Collectors.toList()));
    }

    @Override
    public JsonArrayBuilder set(int index, String value) {
        Objects.requireNonNull(value, "The value to be set must not be null!");
        return this.set(index, JsonFactory.newValue(value));
    }

    private static <T> Stream<T> getStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @Override
    public ImmutableJsonArrayBuilder add(JsonValue value, JsonValue ... furtherValues) {
        ImmutableJsonArrayBuilder.checkValue(value);
        ImmutableJsonArrayBuilder.checkFurtherValues(furtherValues);
        this.values.add(value);
        Collections.addAll(this.values, furtherValues);
        return this;
    }

    @Override
    public ImmutableJsonArrayBuilder addAll(Iterable<? extends JsonValue> values) {
        values.forEach(this.values::add);
        return this;
    }

    @Override
    public JsonArrayBuilder set(int index, JsonValue value) {
        Objects.requireNonNull(value, "The value to be set must not be null!");
        this.values.set(index, value);
        return this;
    }

    @Override
    public Optional<JsonValue> get(int index) {
        try {
            return Optional.of(this.values.get(index));
        }
        catch (IndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }

    @Override
    public JsonArrayBuilder remove(int index) {
        this.values.remove(index);
        return this;
    }

    @Override
    public ImmutableJsonArrayBuilder remove(JsonValue value) {
        Objects.requireNonNull(value, "The value to be removed must not be null!");
        this.values.remove(value);
        return this;
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return this.values.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public Stream<JsonValue> stream() {
        return this.values.stream();
    }

    @Override
    public JsonArray build() {
        return ImmutableJsonArray.of(this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonArrayBuilder that = (ImmutableJsonArrayBuilder)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [values=" + this.values + "]";
    }
}

