/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.AbstractJsonValue;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonNull;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class ImmutableJsonArrayNull
extends AbstractJsonValue
implements JsonArray,
JsonNull {
    @Nullable
    private static ImmutableJsonArrayNull instance = null;

    private ImmutableJsonArrayNull() {
    }

    public static ImmutableJsonArrayNull getInstance() {
        ImmutableJsonArrayNull result = instance;
        if (null == result) {
            instance = result = new ImmutableJsonArrayNull();
        }
        return result;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonArray asArray() {
        return this;
    }

    @Override
    public JsonArray add(int value, int ... furtherValues) {
        return this;
    }

    @Override
    public JsonArray add(long value, long ... furtherValues) {
        return this;
    }

    @Override
    public JsonArray add(double value, double ... furtherValues) {
        return this;
    }

    @Override
    public JsonArray add(boolean value, boolean ... furtherValues) {
        return this;
    }

    @Override
    public JsonArray add(String value, String ... furtherValues) {
        return this;
    }

    @Override
    public JsonArray add(JsonValue value, JsonValue ... furtherValues) {
        return this;
    }

    @Override
    public Optional<JsonValue> get(int index) {
        return Optional.empty();
    }

    @Override
    public boolean contains(JsonValue value) {
        return false;
    }

    @Override
    public int indexOf(JsonValue value) {
        return 0;
    }

    @Override
    public Stream<JsonValue> stream() {
        return Stream.empty();
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int getSize() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof JsonNull;
    }

    public int hashCode() {
        return JsonNull.class.hashCode();
    }

    @Override
    public String toString() {
        return JsonFactory.nullLiteral().toString();
    }
}

