/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.AbstractJsonValue;
import org.eclipse.ditto.json.SerializationContext;

@Immutable
final class ImmutableJsonBoolean
extends AbstractJsonValue {
    static final ImmutableJsonBoolean TRUE = ImmutableJsonBoolean.of(true);
    static final ImmutableJsonBoolean FALSE = ImmutableJsonBoolean.of(false);
    private final boolean value;

    private ImmutableJsonBoolean(boolean theValue) {
        this.value = theValue;
    }

    public static ImmutableJsonBoolean of(boolean value) {
        return new ImmutableJsonBoolean(value);
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean asBoolean() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonBoolean that = (ImmutableJsonBoolean)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void writeValue(SerializationContext serializationContext) throws IOException {
        serializationContext.writeBoolean(this.value);
    }

    @Override
    public long getUpperBoundForStringSize() {
        return 5L;
    }
}

