/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.AbstractJsonNumber;
import org.eclipse.ditto.json.SerializationContext;

@Immutable
final class ImmutableJsonDouble
extends AbstractJsonNumber<Double> {
    private ImmutableJsonDouble(double value) {
        super(value);
    }

    public static ImmutableJsonDouble of(double value) {
        return new ImmutableJsonDouble(value);
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double asDouble() {
        return (Double)this.getValue();
    }

    @Override
    public boolean isInt() {
        Double value = (Double)this.getValue();
        return (double)value.intValue() == value;
    }

    @Override
    public boolean isLong() {
        Double value = (Double)this.getValue();
        return (double)value.longValue() == value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AbstractJsonNumber) {
            AbstractJsonNumber that = (AbstractJsonNumber)o;
            if (this.isInt() && that.isInt()) {
                return Objects.equals(this.asInt(), that.asInt());
            }
            if (this.isLong() && that.isLong()) {
                return Objects.equals(this.asLong(), that.asLong());
            }
            return Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    public int hashCode() {
        if (this.isInt()) {
            return this.asInt();
        }
        if (this.isLong()) {
            return Long.hashCode(this.asLong());
        }
        return ((Double)this.getValue()).hashCode();
    }

    @Override
    public void writeValue(SerializationContext serializationContext) throws IOException {
        double doubleValue = (Double)this.getValue();
        float floatValue = ((Double)this.getValue()).floatValue();
        if ((double)floatValue == doubleValue) {
            serializationContext.writeNumber(floatValue);
        } else {
            serializationContext.writeNumber(doubleValue);
        }
    }

    @Override
    public long getUpperBoundForStringSize() {
        return 24L;
    }
}

