/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JavaStringToEscapedJsonString;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.SerializationContext;

@Immutable
final class ImmutableJsonField
implements JsonField {
    private final JsonKey key;
    private final JsonValue value;
    @Nullable
    private final JsonFieldDefinition definition;
    @Nullable
    private String stringRepresentation;

    private ImmutableJsonField(JsonKey theKey, JsonValue theValue, @Nullable JsonFieldDefinition theDefinition) {
        this.key = Objects.requireNonNull(theKey, "The JSON key must not be null!");
        this.value = Objects.requireNonNull(theValue, "The JSON value must not be null!");
        this.definition = theDefinition;
        this.stringRepresentation = null;
    }

    public static ImmutableJsonField newInstance(JsonKey key, JsonValue value) {
        return ImmutableJsonField.newInstance(key, value, null);
    }

    public static ImmutableJsonField newInstance(JsonKey key, JsonValue value, @Nullable JsonFieldDefinition definition) {
        return new ImmutableJsonField(key, value, definition);
    }

    @Override
    public String getKeyName() {
        return this.key.toString();
    }

    @Override
    public JsonKey getKey() {
        return this.key;
    }

    @Override
    public JsonValue getValue() {
        return this.value;
    }

    @Override
    public Optional<JsonFieldDefinition> getDefinition() {
        return Optional.ofNullable(this.definition);
    }

    @Override
    public boolean isMarkedAs(JsonFieldMarker fieldMarker, JsonFieldMarker ... furtherFieldMarkers) {
        return null != this.definition && this.definition.isMarkedAs(fieldMarker, furtherFieldMarkers);
    }

    @Override
    public void writeKeyAndValue(SerializationContext serializationContext) throws IOException {
        serializationContext.writeFieldName(this.key.toString());
        this.value.writeValue(serializationContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonField that = (ImmutableJsonField)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        String result = this.stringRepresentation;
        if (null == result) {
            this.stringRepresentation = result = this.getEscapedKeyName() + ":" + this.value;
        }
        return result;
    }

    private String getEscapedKeyName() {
        JavaStringToEscapedJsonString javaStringToEscapeJsonString = JavaStringToEscapedJsonString.getInstance();
        return (String)javaStringToEscapeJsonString.apply(this.key.toString());
    }
}

