/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonPointer;

@Immutable
final class ImmutableJsonFieldSelector
implements JsonFieldSelector {
    static final String COMMA = ",";
    private final Set<JsonPointer> pointers;
    private final String jsonFieldSelectorString;

    private ImmutableJsonFieldSelector(Iterable<JsonPointer> thePointers, @Nullable String theJsonFieldSelectorString) {
        LinkedHashSet pointersSet = new LinkedHashSet();
        thePointers.forEach(p -> {
            if (!p.isEmpty()) {
                pointersSet.add(p);
            }
        });
        this.pointers = Collections.unmodifiableSet(pointersSet);
        this.jsonFieldSelectorString = theJsonFieldSelectorString != null ? theJsonFieldSelectorString : ImmutableJsonFieldSelector.calculateFieldSelectorString(this.pointers);
    }

    public static ImmutableJsonFieldSelector empty() {
        return ImmutableJsonFieldSelector.of(Collections.emptyList(), null);
    }

    public static ImmutableJsonFieldSelector of(Iterable<JsonPointer> pointers) {
        return ImmutableJsonFieldSelector.of(pointers, null);
    }

    public static ImmutableJsonFieldSelector of(Iterable<JsonPointer> pointers, @Nullable String fieldSelectorString) {
        Objects.requireNonNull(pointers, "The JSON pointers must not be null!");
        return new ImmutableJsonFieldSelector(pointers, fieldSelectorString);
    }

    @Override
    public Set<JsonPointer> getPointers() {
        return this.pointers;
    }

    @Override
    public int getSize() {
        return this.pointers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.pointers.isEmpty();
    }

    @Override
    public Iterator<JsonPointer> iterator() {
        return this.pointers.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonFieldSelector that = (ImmutableJsonFieldSelector)o;
        return Objects.equals(this.pointers, that.pointers) && Objects.equals(this.jsonFieldSelectorString, that.jsonFieldSelectorString);
    }

    public int hashCode() {
        return Objects.hash(this.pointers, this.jsonFieldSelectorString);
    }

    @Override
    public String toString() {
        return this.jsonFieldSelectorString;
    }

    private static String calculateFieldSelectorString(Collection<JsonPointer> thePointers) {
        return thePointers.stream().map(JsonPointer::toString).collect(Collectors.joining(COMMA));
    }
}

