/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.ImmutableJsonFieldSelector;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonFieldSelectorBuilder;
import org.eclipse.ditto.json.JsonParseOptions;
import org.eclipse.ditto.json.JsonPointer;

@NotThreadSafe
final class ImmutableJsonFieldSelectorBuilder
implements JsonFieldSelectorBuilder {
    private final Set<JsonPointer> pointers = new LinkedHashSet<JsonPointer>();
    @Nullable
    private String jsonFieldSelectorString;

    private ImmutableJsonFieldSelectorBuilder() {
    }

    public static ImmutableJsonFieldSelectorBuilder newInstance() {
        return new ImmutableJsonFieldSelectorBuilder();
    }

    @Override
    public JsonFieldSelectorBuilder addPointerString(String pointerString, String ... furtherPointerStrings) {
        Objects.requireNonNull(furtherPointerStrings, "The further JSON pointer strings to be added must not be null!");
        this.addPointerString(pointerString);
        for (String furtherPointerString : furtherPointerStrings) {
            this.addPointerString(furtherPointerString);
        }
        return this;
    }

    private void addPointerString(@Nullable CharSequence pointerString) {
        if (null != pointerString) {
            this.pointers.add(JsonFactory.newPointer(pointerString));
        }
    }

    @Override
    public JsonFieldSelectorBuilder addPointerStrings(Iterable<String> pointerStrings) {
        Objects.requireNonNull(pointerStrings, "The JSON pointer strings to be added must not be null!");
        for (String pointerString : pointerStrings) {
            this.addPointerString(pointerString);
        }
        return this;
    }

    @Override
    public JsonFieldSelectorBuilder addPointer(@Nullable JsonPointer pointer, JsonPointer ... furtherPointers) {
        Objects.requireNonNull(furtherPointers, "The further JSON pointers to be added must not be null!");
        this.addPointer(pointer);
        for (JsonPointer furtherPointer : furtherPointers) {
            this.addPointer(furtherPointer);
        }
        return this;
    }

    private void addPointer(@Nullable JsonPointer pointer) {
        boolean pointerAdded;
        boolean bl = pointerAdded = null != pointer && this.pointers.add(pointer);
        if (null != this.jsonFieldSelectorString && pointerAdded) {
            this.jsonFieldSelectorString = null;
        }
    }

    @Override
    public JsonFieldSelectorBuilder addPointers(Iterable<JsonPointer> pointers) {
        Objects.requireNonNull(pointers, "The JSON pointers to be added must not be null!");
        for (JsonPointer pointer : pointers) {
            this.addPointer(pointer);
        }
        return this;
    }

    @Override
    public JsonFieldSelectorBuilder addFieldDefinition(@Nullable JsonFieldDefinition fieldDefinition, JsonFieldDefinition ... furtherFieldDefinitions) {
        Objects.requireNonNull(furtherFieldDefinitions, "The further JSON field definitions to be added must not be null!");
        this.addFieldDefinition(fieldDefinition);
        for (JsonFieldDefinition furtherFieldDefinition : furtherFieldDefinitions) {
            this.addFieldDefinition(furtherFieldDefinition);
        }
        return this;
    }

    private void addFieldDefinition(@Nullable JsonFieldDefinition fieldDefinition) {
        if (null != fieldDefinition) {
            this.addPointer(fieldDefinition.getPointer());
        }
    }

    @Override
    public JsonFieldSelectorBuilder addFieldDefinitions(Iterable<JsonFieldDefinition> fieldDefinitions) {
        Objects.requireNonNull(fieldDefinitions, "The JSON field definitions must not be null!");
        for (JsonFieldDefinition fieldDefinition : fieldDefinitions) {
            this.addFieldDefinition(fieldDefinition);
        }
        return this;
    }

    @Override
    public JsonFieldSelectorBuilder addFieldSelector(JsonFieldSelector fieldSelector) {
        return this.addPointers(Objects.requireNonNull(fieldSelector, "The JSON field selector must not be null!"));
    }

    @Override
    public JsonFieldSelectorBuilder addFieldSelectorString(@Nullable String fieldSelectorString, JsonParseOptions options) {
        Objects.requireNonNull(options, "The JSON parse options must not be null!");
        if (null == fieldSelectorString || fieldSelectorString.isEmpty()) {
            return this;
        }
        JsonFieldSelector fieldSelector = JsonFactory.newFieldSelector(fieldSelectorString, options);
        boolean arePointersInitiallyEmpty = this.pointers.isEmpty();
        this.addPointers(fieldSelector);
        if (arePointersInitiallyEmpty) {
            this.jsonFieldSelectorString = fieldSelectorString;
        }
        return this;
    }

    @Override
    public JsonFieldSelectorBuilder addFieldSelectorString(@Nullable String fieldSelectorString) {
        JsonParseOptions options = JsonFactory.newParseOptionsBuilder().withoutUrlDecoding().build();
        return this.addFieldSelectorString(fieldSelectorString, options);
    }

    @Override
    public JsonFieldSelectorBuilder removePointer(@Nullable JsonPointer jsonPointer) {
        boolean pointerRemoved;
        boolean bl = pointerRemoved = null != jsonPointer && this.pointers.remove(jsonPointer);
        if (pointerRemoved) {
            this.resetJsonFieldSelectorString();
        }
        return this;
    }

    @Override
    public JsonFieldSelectorBuilder removePointers(Iterable<JsonPointer> jsonPointers) {
        Objects.requireNonNull(jsonPointers, "The JSON Pointers to be removed must not be null!");
        for (JsonPointer jsonPointer : jsonPointers) {
            this.removePointer(jsonPointer);
        }
        return this;
    }

    @Override
    public JsonFieldSelectorBuilder removePointerString(@Nullable String pointerString) {
        if (null == pointerString) {
            return this;
        }
        return this.removePointer(JsonFactory.newPointer(pointerString));
    }

    @Override
    public JsonFieldSelectorBuilder removePointerStrings(Iterable<String> pointerStrings) {
        Objects.requireNonNull(pointerStrings, "The JSON Pointer strings to be removed must not be null!");
        for (String pointerString : pointerStrings) {
            this.removePointerString(pointerString);
        }
        return this;
    }

    @Override
    public JsonFieldSelectorBuilder removeFieldDefinition(@Nullable JsonFieldDefinition fieldDefinition) {
        if (null == fieldDefinition) {
            return this;
        }
        return this.removePointer(fieldDefinition.getPointer());
    }

    @Override
    public JsonFieldSelectorBuilder removeFieldDefinitions(Iterable<JsonFieldDefinition> fieldDefinitions) {
        Objects.requireNonNull(fieldDefinitions, "The JSON field definitions to be removed must not be null!");
        for (JsonFieldDefinition fieldDefinition : fieldDefinitions) {
            this.removeFieldDefinition(fieldDefinition);
        }
        return this;
    }

    private void resetJsonFieldSelectorString() {
        if (null != this.jsonFieldSelectorString) {
            this.jsonFieldSelectorString = null;
        }
    }

    @Override
    public Iterator<JsonPointer> iterator() {
        return new JsonPointerIterator(this.pointers.iterator());
    }

    @Override
    public JsonFieldSelector build() {
        return ImmutableJsonFieldSelector.of(this.pointers, this.jsonFieldSelectorString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonFieldSelectorBuilder that = (ImmutableJsonFieldSelectorBuilder)o;
        return Objects.equals(this.pointers, that.pointers);
    }

    public int hashCode() {
        return Objects.hash(this.pointers);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [pointers=" + this.pointers + "]";
    }

    private final class JsonPointerIterator
    implements Iterator<JsonPointer> {
        private final Iterator<JsonPointer> pointerIterator;
        private JsonPointer currentPointer;

        private JsonPointerIterator(Iterator<JsonPointer> thePointerIterator) {
            this.pointerIterator = thePointerIterator;
            this.currentPointer = null;
        }

        @Override
        public boolean hasNext() {
            return this.pointerIterator.hasNext();
        }

        @Override
        public JsonPointer next() {
            this.currentPointer = this.pointerIterator.next();
            return this.currentPointer;
        }

        @Override
        public void remove() {
            this.pointerIterator.remove();
            if (null != this.currentPointer) {
                ImmutableJsonFieldSelectorBuilder.this.resetJsonFieldSelectorString();
                this.currentPointer = null;
            }
        }
    }
}

