/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.ImmutableJsonFieldSelector;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonFieldSelectorInvalidException;
import org.eclipse.ditto.json.JsonParseOptions;
import org.eclipse.ditto.json.JsonPointer;

@Immutable
final class ImmutableJsonFieldSelectorFactory {
    private static final String OPENING_PARENTHESIS = "(";
    private static final String CLOSING_PARENTHESIS = ")";
    private final String jsonFieldSelectorString;

    private ImmutableJsonFieldSelectorFactory(String theJsonFieldSelectorString) {
        this.jsonFieldSelectorString = theJsonFieldSelectorString;
        this.validateJsonFieldSelectorString();
    }

    public static ImmutableJsonFieldSelectorFactory newInstance(String jsonFieldSelectorString, JsonParseOptions jsonParseOptions) {
        Objects.requireNonNull(jsonFieldSelectorString, "The JSON field selector string must not be null!");
        Objects.requireNonNull(jsonParseOptions, "The JSON parse options must not be null!");
        String decodedJsonFieldSelectorString = ImmutableJsonFieldSelectorFactory.tryToDecodeString(jsonFieldSelectorString, jsonParseOptions);
        return new ImmutableJsonFieldSelectorFactory(decodedJsonFieldSelectorString);
    }

    private static String tryToDecodeString(String s, JsonParseOptions jsonParseOptions) {
        try {
            return ImmutableJsonFieldSelectorFactory.decode(s, jsonParseOptions);
        }
        catch (Exception e) {
            throw (JsonFieldSelectorInvalidException)JsonFieldSelectorInvalidException.newBuilder().fieldSelector(s).description("Check if the field selector is correctly URL encoded.").cause(e).build();
        }
    }

    private static String decode(String s, JsonParseOptions jsonParseOptions) throws UnsupportedEncodingException {
        if (jsonParseOptions.isApplyUrlDecoding()) {
            return URLDecoder.decode(s, "UTF-8");
        }
        return s;
    }

    private static List<String> splitAroundComma(String toSplit) {
        ArrayList<String> topLevelFields = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(toSplit.length());
        int waitForClosingParenthesesCnt = 0;
        char[] cArray = toSplit.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (c.charValue() == '(') {
                ++waitForClosingParenthesesCnt;
                sb.append(c);
                continue;
            }
            if (waitForClosingParenthesesCnt > 0) {
                if (c.charValue() == ')') {
                    --waitForClosingParenthesesCnt;
                }
                sb.append(c);
                continue;
            }
            if (c.charValue() != ',') {
                sb.append(c);
                continue;
            }
            topLevelFields.add(sb.toString());
            sb.setLength(0);
        }
        topLevelFields.add(sb.toString());
        return topLevelFields;
    }

    private static Set<JsonPointer> flattenToJsonPointers(Iterable<String> rawJsonKeys) {
        LinkedHashSet<JsonPointer> result = new LinkedHashSet<JsonPointer>();
        for (String rawJsonKey : rawJsonKeys) {
            if (ImmutableJsonFieldSelectorFactory.isJsonSelectorFormat(rawJsonKey)) {
                result.addAll(ImmutableJsonFieldSelectorFactory.flattenToJsonPointers(rawJsonKey));
                continue;
            }
            result.add(JsonFactory.newPointer(rawJsonKey));
        }
        return result;
    }

    private static boolean isJsonSelectorFormat(String jsonKey) {
        if (jsonKey.contains(OPENING_PARENTHESIS)) {
            int iClosingParenthesis;
            int iOpeningParenthesis = jsonKey.indexOf(OPENING_PARENTHESIS);
            return iOpeningParenthesis < (iClosingParenthesis = jsonKey.indexOf(CLOSING_PARENTHESIS));
        }
        return false;
    }

    private static Collection<JsonPointer> flattenToJsonPointers(String stringWithParentheses) {
        int indexOfOpeningParenthesis = stringWithParentheses.indexOf(OPENING_PARENTHESIS);
        String commonRootKey = stringWithParentheses.substring(0, indexOfOpeningParenthesis);
        JsonPointer commonRootPointer = JsonFactory.newPointer(commonRootKey);
        String withoutParentheses = stringWithParentheses.substring(indexOfOpeningParenthesis + 1, stringWithParentheses.length() - 1);
        Set<JsonPointer> jsonPointers = ImmutableJsonFieldSelectorFactory.flattenToJsonPointers(ImmutableJsonFieldSelectorFactory.splitAroundComma(withoutParentheses));
        return jsonPointers.stream().map(commonRootPointer::append).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void validateJsonFieldSelectorString() {
        int closedParenthesesCnt;
        int openedParenthesesCnt;
        if (this.jsonFieldSelectorString.isEmpty()) {
            throw (JsonFieldSelectorInvalidException)JsonFieldSelectorInvalidException.newBuilder().fieldSelector(this.jsonFieldSelectorString).build();
        }
        if (this.jsonFieldSelectorString.contains(OPENING_PARENTHESIS) && (openedParenthesesCnt = this.getCountOf(OPENING_PARENTHESIS)) != (closedParenthesesCnt = this.getCountOf(CLOSING_PARENTHESIS))) {
            throw (JsonFieldSelectorInvalidException)JsonFieldSelectorInvalidException.newBuilder().fieldSelector(this.jsonFieldSelectorString).build();
        }
    }

    private int getCountOf(CharSequence parenthesis) {
        return this.jsonFieldSelectorString.length() - this.jsonFieldSelectorString.replace(parenthesis, "").length();
    }

    public JsonFieldSelector newJsonFieldSelector() {
        List<String> rawJsonKeys = ImmutableJsonFieldSelectorFactory.splitAroundComma(this.jsonFieldSelectorString);
        Set<JsonPointer> jsonPointers = ImmutableJsonFieldSelectorFactory.flattenToJsonPointers(rawJsonKeys);
        return ImmutableJsonFieldSelector.of(jsonPointers, this.jsonFieldSelectorString);
    }
}

