/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.AbstractJsonNumber;
import org.eclipse.ditto.json.SerializationContext;

@Immutable
final class ImmutableJsonInt
extends AbstractJsonNumber<Integer> {
    private ImmutableJsonInt(int value) {
        super(value);
    }

    public static ImmutableJsonInt of(int value) {
        return new ImmutableJsonInt(value);
    }

    @Override
    public boolean isInt() {
        return true;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    public boolean equals(@Nullable Object o) {
        AbstractJsonNumber that;
        if (this == o) {
            return true;
        }
        if (o instanceof AbstractJsonNumber && (that = (AbstractJsonNumber)o).isInt()) {
            return Objects.equals(this.getValue(), that.asInt());
        }
        return false;
    }

    public int hashCode() {
        return (Integer)this.getValue();
    }

    @Override
    public void writeValue(SerializationContext serializationContext) throws IOException {
        serializationContext.writeNumber((Integer)this.getValue());
    }

    @Override
    public long getUpperBoundForStringSize() {
        return 11L;
    }
}

