/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonPointer;

@Immutable
final class ImmutableJsonKey
implements JsonKey {
    private final String keyValue;

    private ImmutableJsonKey(String theKeyValue) {
        this.keyValue = theKeyValue;
    }

    public static JsonKey of(CharSequence keyValue) {
        Objects.requireNonNull(keyValue, "The key string must not be null!");
        if (JsonKey.class.isAssignableFrom(keyValue.getClass())) {
            return (JsonKey)keyValue;
        }
        if (0 == keyValue.length()) {
            throw new IllegalArgumentException("The key string must not be empty!");
        }
        return new ImmutableJsonKey(keyValue.toString());
    }

    @Override
    public JsonPointer asPointer() {
        return JsonFactory.newPointer(this);
    }

    @Override
    public int length() {
        return this.keyValue.length();
    }

    @Override
    public char charAt(int index) {
        return this.keyValue.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.keyValue.subSequence(start, end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonKey that = (ImmutableJsonKey)o;
        return Objects.equals(this.keyValue, that.keyValue);
    }

    public int hashCode() {
        return Objects.hash(this.keyValue);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.keyValue;
    }
}

