/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.AbstractJsonNumber;
import org.eclipse.ditto.json.SerializationContext;

@Immutable
final class ImmutableJsonLong
extends AbstractJsonNumber<Long> {
    private ImmutableJsonLong(long value) {
        super(value);
    }

    public static ImmutableJsonLong of(long value) {
        return new ImmutableJsonLong(value);
    }

    @Override
    public boolean isInt() {
        Long value = (Long)this.getValue();
        return (long)value.intValue() == value;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    public boolean equals(Object o) {
        AbstractJsonNumber that;
        if (this == o) {
            return true;
        }
        if (o instanceof AbstractJsonNumber && (that = (AbstractJsonNumber)o).isLong()) {
            return Objects.equals(this.getValue(), that.asLong());
        }
        return false;
    }

    public int hashCode() {
        Long value = (Long)this.getValue();
        if (this.isInt()) {
            return value.intValue();
        }
        return value.hashCode();
    }

    @Override
    public void writeValue(SerializationContext serializationContext) throws IOException {
        serializationContext.writeNumber((Long)this.getValue());
    }

    @Override
    public long getUpperBoundForStringSize() {
        return 21L;
    }
}

