/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.AbstractJsonValue;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonNull;
import org.eclipse.ditto.json.JsonObject;

@Immutable
final class ImmutableJsonNull
extends AbstractJsonValue
implements JsonNull {
    private static final ImmutableJsonNull INSTANCE = new ImmutableJsonNull();

    private ImmutableJsonNull() {
    }

    public static ImmutableJsonNull getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonObject asObject() {
        return JsonFactory.nullObject();
    }

    @Override
    public JsonArray asArray() {
        return JsonFactory.nullArray();
    }

    public boolean equals(@Nullable Object o) {
        return this == o || null != o && (super.equals(o) || o instanceof JsonNull);
    }

    public int hashCode() {
        return JsonNull.class.hashCode();
    }

    @Override
    public String toString() {
        return "null";
    }
}

