/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.AbstractJsonValue;
import org.eclipse.ditto.json.CborFactory;
import org.eclipse.ditto.json.DefaultDittoJsonHandler;
import org.eclipse.ditto.json.DittoJsonHandler;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonFieldSelectorTrie;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.JsonValueParser;
import org.eclipse.ditto.json.NoopCborFactory;
import org.eclipse.ditto.json.SerializationContext;

@Immutable
final class ImmutableJsonObject
extends AbstractJsonValue
implements JsonObject {
    private static final JsonKey ROOT_KEY = JsonKey.of("/");
    @Nullable
    private static ImmutableJsonObject emptyInstance = null;
    private final SoftReferencedFieldMap fieldMap;

    ImmutableJsonObject(SoftReferencedFieldMap theFieldMap) {
        this.fieldMap = theFieldMap;
    }

    public static ImmutableJsonObject empty() {
        ImmutableJsonObject result = emptyInstance;
        if (null == result) {
            emptyInstance = result = new ImmutableJsonObject(SoftReferencedFieldMap.empty());
        }
        return result;
    }

    public static ImmutableJsonObject of(Map<String, JsonField> fields) {
        return new ImmutableJsonObject(SoftReferencedFieldMap.of(fields));
    }

    public static ImmutableJsonObject of(Map<String, JsonField> fields, @Nullable String stringRepresentation) {
        return new ImmutableJsonObject(SoftReferencedFieldMap.of(fields, stringRepresentation));
    }

    public static ImmutableJsonObject of(Map<String, JsonField> fields, @Nullable byte[] cborRepresentation) {
        return new ImmutableJsonObject(SoftReferencedFieldMap.of(fields, cborRepresentation != null ? (byte[])cborRepresentation.clone() : null));
    }

    @Override
    public JsonObject setValue(CharSequence key, int value) {
        return this.setValue(key, JsonValue.of(value));
    }

    @Override
    public JsonObject setValue(CharSequence key, long value) {
        return this.setValue(key, JsonValue.of(value));
    }

    @Override
    public JsonObject setValue(CharSequence key, double value) {
        return this.setValue(key, JsonValue.of(value));
    }

    @Override
    public JsonObject setValue(CharSequence key, boolean value) {
        return this.setValue(key, JsonValue.of(value));
    }

    @Override
    public JsonObject setValue(CharSequence key, String value) {
        return this.setValue(key, JsonValue.of(value));
    }

    @Override
    public JsonObject setValue(CharSequence key, JsonValue value) {
        JsonPointer pointer = JsonFactory.getNonEmptyPointer(key);
        JsonKey leafKey = pointer.getLeaf().orElse(ROOT_KEY);
        Optional<JsonFieldDefinition> keyDefinition = this.getDefinitionForKey(leafKey);
        return ImmutableJsonObject.setFieldInHierarchy(this, pointer, JsonField.newInstance(leafKey, value, keyDefinition.orElse(null)));
    }

    private Optional<JsonFieldDefinition> getDefinitionForKey(CharSequence key) {
        return this.getField(key).flatMap(JsonField::getDefinition);
    }

    @Override
    public <T> JsonObject set(JsonFieldDefinition<T> fieldDefinition, @Nullable T value) {
        Objects.requireNonNull(fieldDefinition, "The JSON field definition to set the value for must not be null!");
        JsonPointer pointer = fieldDefinition.getPointer();
        JsonKey leafKey = pointer.getLeaf().orElseThrow(() -> {
            String msgTemplate = "The pointer of the field definition <{0}> must not be empty!";
            return new IllegalArgumentException(MessageFormat.format("The pointer of the field definition <{0}> must not be empty!", fieldDefinition));
        });
        JsonField field = JsonField.newInstance(leafKey, JsonValue.of(value), fieldDefinition);
        return ImmutableJsonObject.setFieldInHierarchy(this, pointer, field);
    }

    private static JsonObject setFieldInHierarchy(JsonObject target, JsonPointer pointer, JsonField jsonField) {
        if (1 >= pointer.getLevelCount()) {
            return target.set(jsonField);
        }
        JsonKey rootKey = pointer.getRoot().orElse(ROOT_KEY);
        JsonObject newTarget = target.getValue(rootKey).filter(JsonValue::isObject).filter(jsonValue -> !jsonValue.isNull()).map(JsonValue::asObject).orElseGet(ImmutableJsonObject::empty);
        return target.setValue((CharSequence)rootKey, ImmutableJsonObject.setFieldInHierarchy(newTarget, pointer.nextLevel(), jsonField));
    }

    @Override
    public ImmutableJsonObject set(JsonField field) {
        Objects.requireNonNull(field, "The JSON field to be set must not be null!");
        ImmutableJsonObject result = this;
        JsonField existingField = this.fieldMap.getOrNull(field.getKeyName());
        if (!field.equals(existingField)) {
            result = new ImmutableJsonObject(this.fieldMap.put(field.getKeyName(), field));
        }
        return result;
    }

    @Override
    public JsonObject setAll(Iterable<JsonField> fields) {
        Objects.requireNonNull(fields, "The JSON fields to add must not be null!");
        ImmutableJsonObject result = ImmutableJsonObject.isEmpty(fields) ? this : new ImmutableJsonObject(this.fieldMap.putAll(fields));
        return result;
    }

    private static boolean isEmpty(Iterable<?> iterable) {
        Iterator<?> iterator = iterable.iterator();
        return !iterator.hasNext();
    }

    @Override
    public boolean contains(CharSequence key) {
        Objects.requireNonNull(key, "The key or pointer to check the existence of a value for must not be null!");
        JsonPointer pointer = JsonPointer.of(key);
        boolean result = 1 >= pointer.getLevelCount() ? pointer.getRoot().map(this::containsKey).orElse(false).booleanValue() : pointer.getRoot().flatMap(this::getValueForKey).filter(JsonValue::isObject).map(JsonValue::asObject).map(jsonObject -> jsonObject.contains(pointer.nextLevel())).orElse(false).booleanValue();
        return result;
    }

    private boolean containsKey(CharSequence key) {
        return this.fieldMap.containsKey(key.toString());
    }

    @Override
    public Optional<JsonValue> getValue(CharSequence key) {
        Objects.requireNonNull(key, "The key or pointer of the value to be retrieved must not be null!");
        return this.getValueForPointer(JsonPointer.of(key));
    }

    private Optional<JsonValue> getValueForPointer(JsonPointer pointer) {
        JsonKey rootKey = pointer.getRoot().orElse(ROOT_KEY);
        int levelCount = pointer.getLevelCount();
        Optional<JsonValue> result = 0 == levelCount ? Optional.of(this) : (1 == levelCount ? this.getValueForKey(rootKey) : this.getValueForKey(rootKey).filter(JsonValue::isObject).map(JsonValue::asObject).flatMap(jsonObject -> jsonObject.getValue(pointer.nextLevel())));
        return result;
    }

    private Optional<JsonValue> getValueForKey(CharSequence key) {
        JsonField jsonField = this.fieldMap.getOrNull(key.toString());
        return null != jsonField ? Optional.of(jsonField.getValue()) : Optional.empty();
    }

    @Override
    public <T> Optional<T> getValue(JsonFieldDefinition<T> fieldDefinition) {
        ImmutableJsonObject.checkFieldDefinition(fieldDefinition);
        return this.getValueForPointer(fieldDefinition.getPointer()).map(fieldDefinition::mapValue);
    }

    private static void checkFieldDefinition(JsonFieldDefinition fieldDefinition) {
        Objects.requireNonNull(fieldDefinition, "The JSON field definition which supplies the pointer must not be null!");
    }

    @Override
    public <T> T getValueOrThrow(JsonFieldDefinition<T> fieldDefinition) {
        return this.getValue(fieldDefinition).orElseThrow(() -> new JsonMissingFieldException(fieldDefinition));
    }

    @Override
    public JsonObject get(JsonPointer pointer) {
        JsonObject result;
        ImmutableJsonObject.checkPointer(pointer);
        if (pointer.isEmpty()) {
            return this;
        }
        JsonKey rootKey = pointer.getRoot().orElse(ROOT_KEY);
        Optional<JsonValue> rootKeyValue = this.getValueForKey(rootKey);
        Optional<JsonFieldDefinition> rootKeyDefinition = this.getDefinitionForKey(rootKey);
        if (1 >= pointer.getLevelCount()) {
            result = rootKeyValue.map(jsonValue -> JsonField.newInstance(rootKey, jsonValue, rootKeyDefinition.orElse(null))).map(jsonField -> Collections.singletonMap(jsonField.getKeyName(), jsonField)).map(ImmutableJsonObject::of).orElseGet(ImmutableJsonObject::empty);
        } else {
            JsonPointer nextPointerLevel = pointer.nextLevel();
            Predicate<JsonObject> containsNextLevelRootKey = jsonObject -> nextPointerLevel.getRoot().filter(jsonObject::contains).isPresent();
            result = rootKeyValue.map(jsonValue -> {
                if (jsonValue.isObject()) {
                    if (containsNextLevelRootKey.test(jsonValue.asObject())) {
                        return jsonValue.asObject().get(nextPointerLevel);
                    }
                    return null;
                }
                return jsonValue;
            }).map(jsonValue -> JsonField.newInstance(rootKey, jsonValue, rootKeyDefinition.orElse(null))).map(jsonField -> Collections.singletonMap(jsonField.getKeyName(), jsonField)).map(ImmutableJsonObject::of).orElseGet(ImmutableJsonObject::empty);
        }
        return result;
    }

    private static void checkPointer(JsonPointer pointer) {
        Objects.requireNonNull(pointer, "The JSON pointer must not be null!");
    }

    @Override
    public JsonObject get(JsonFieldDefinition fieldDefinition) {
        ImmutableJsonObject.checkFieldDefinition(fieldDefinition);
        return this.get(fieldDefinition.getPointer());
    }

    @Override
    public JsonObject get(JsonFieldSelector fieldSelector) {
        Objects.requireNonNull(fieldSelector, "The JSON field selector must not be null!");
        if (this.isEmpty()) {
            return this;
        }
        List<JsonPointer> pointersContainedInThis = fieldSelector.getPointers().stream().filter(this::contains).collect(Collectors.toList());
        if (pointersContainedInThis.isEmpty()) {
            return ImmutableJsonObject.empty();
        }
        return ImmutableJsonObject.filterByTrie(this, JsonFieldSelectorTrie.of(pointersContainedInThis));
    }

    private static JsonObject filterByTrie(JsonObject self, JsonFieldSelectorTrie trie) {
        if (trie.isEmpty()) {
            return self;
        }
        JsonObjectBuilder builder = JsonObject.newBuilder();
        for (JsonKey key : trie.getKeys()) {
            self.getField(key).ifPresent(child -> {
                JsonValue childValue = child.getValue();
                JsonValue filteredChildValue = childValue.isObject() ? ImmutableJsonObject.filterByTrie(childValue.asObject(), trie.descend(key)) : childValue;
                Optional<JsonFieldDefinition> childFieldDefinition = child.getDefinition();
                if (childFieldDefinition.isPresent()) {
                    builder.set(childFieldDefinition.get(), filteredChildValue);
                } else {
                    builder.set((CharSequence)key, filteredChildValue);
                }
            });
        }
        return builder.build();
    }

    @Override
    public JsonObject remove(CharSequence key) {
        Objects.requireNonNull(key, "The key or pointer of the field to be removed must not be null!");
        return this.removeForPointer(JsonPointer.of(key));
    }

    private JsonObject removeForPointer(JsonPointer pointer) {
        JsonObject result;
        JsonKey rootKey = pointer.getRoot().orElse(ROOT_KEY);
        Optional<JsonFieldDefinition> rootKeyDefinition = this.getDefinitionForKey(rootKey);
        if (pointer.isEmpty()) {
            result = this;
        } else if (1 == pointer.getLevelCount()) {
            result = this.removeValueForKey(rootKey);
        } else {
            JsonPointer nextPointerLevel = pointer.nextLevel();
            Predicate<JsonObject> containsNextLevelRootKey = jsonObject -> nextPointerLevel.getRoot().map(jsonObject::contains).orElse(false);
            result = this.getValueForKey(rootKey).filter(JsonValue::isObject).map(JsonValue::asObject).filter(containsNextLevelRootKey).map(jsonObject -> jsonObject.remove(nextPointerLevel)).map(withoutValue -> JsonField.newInstance(rootKey, withoutValue, rootKeyDefinition.orElse(null))).map(this::set).orElse(this);
        }
        return result;
    }

    private JsonObject removeValueForKey(CharSequence key) {
        ImmutableJsonObject result = this;
        if (this.containsKey(key)) {
            result = new ImmutableJsonObject(this.fieldMap.remove(key.toString()));
        }
        return result;
    }

    @Override
    public List<JsonKey> getKeys() {
        List keys = this.fieldMap.getStream().map(JsonField::getKey).collect(Collectors.toList());
        return Collections.unmodifiableList(keys);
    }

    @Override
    public Optional<JsonField> getField(CharSequence key) {
        Objects.requireNonNull(key, "The key or pointer of the field to be retrieved must not be null!");
        JsonPointer pointer = JsonPointer.of(key);
        Optional<JsonField> result = pointer.getRoot().map(Object::toString).map(this.fieldMap::getOrNull);
        if (1 < pointer.getLevelCount()) {
            result = result.map(JsonField::getValue).filter(JsonValue::isObject).map(JsonValue::asObject).flatMap(jsonObject -> jsonObject.getField(pointer.nextLevel()));
        }
        return result;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public JsonObject asObject() {
        return this;
    }

    @Override
    public Iterator<JsonField> iterator() {
        return this.fieldMap.getIterator();
    }

    @Override
    public Stream<JsonField> stream() {
        return this.fieldMap.getStream();
    }

    @Override
    public boolean isEmpty() {
        return this.fieldMap.isEmpty();
    }

    @Override
    public int getSize() {
        return this.fieldMap.getSize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonObject that = (ImmutableJsonObject)o;
        return Objects.equals(this.fieldMap, that.fieldMap);
    }

    public int hashCode() {
        return this.fieldMap.hashCode();
    }

    @Override
    public String toString() {
        return this.fieldMap.asJsonObjectString();
    }

    @Override
    public void writeValue(SerializationContext serializationContext) throws IOException {
        this.fieldMap.writeValue(serializationContext);
    }

    @Override
    public long getUpperBoundForStringSize() {
        return this.fieldMap.upperBoundForStringSize();
    }

    @NotThreadSafe
    static final class FieldMapJsonHandler
    extends DittoJsonHandler<List<JsonValue>, List<JsonField>, Map<String, JsonField>> {
        private final DefaultDittoJsonHandler defaultHandler = DefaultDittoJsonHandler.newInstance();
        private Map<String, JsonField> value = null;
        private final Deque<List<JsonField>> jsonObjectBuilders = new ArrayDeque<List<JsonField>>();
        private int level = 0;

        FieldMapJsonHandler() {
        }

        public List<JsonValue> startArray() {
            return this.defaultHandler.startArray();
        }

        public List<JsonField> startObject() {
            if (0 < this.level) {
                this.jsonObjectBuilders.push((List<JsonField>)this.defaultHandler.startObject());
            }
            ArrayList<JsonField> result = new ArrayList<JsonField>();
            ++this.level;
            return result;
        }

        public void endNull() {
            this.defaultHandler.endNull();
        }

        public void endBoolean(boolean value) {
            this.defaultHandler.endBoolean(value);
        }

        public void endString(String string) {
            this.defaultHandler.endString(string);
        }

        public void endNumber(String string) {
            this.defaultHandler.endNumber(string);
        }

        public void endArray(List<JsonValue> jsonValues) {
            this.defaultHandler.endArray(jsonValues);
        }

        public void endArrayValue(List<JsonValue> jsonValues) {
            this.defaultHandler.endArrayValue(jsonValues);
        }

        public void endObjectValue(List<JsonField> jsonFields, String name) {
            List<JsonField> jsonObjectBuilder = this.jsonObjectBuilders.peek();
            if (null != jsonObjectBuilder) {
                this.defaultHandler.endObjectValue(jsonObjectBuilder, name);
            } else {
                jsonFields.add(JsonField.newInstance(name, this.defaultHandler.getValue()));
            }
        }

        public void endObject(List<JsonField> jsonFields) {
            List<JsonField> jsonObjectBuilder = this.jsonObjectBuilders.poll();
            if (null != jsonObjectBuilder) {
                this.defaultHandler.endObject(jsonObjectBuilder);
            } else {
                LinkedHashMap<String, JsonField> linkedHashMap = new LinkedHashMap<String, JsonField>(jsonFields.size());
                for (JsonField jsonField : jsonFields) {
                    linkedHashMap.put(jsonField.getKeyName(), jsonField);
                }
                this.value = linkedHashMap;
            }
            --this.level;
        }

        @Override
        protected Map<String, JsonField> getValue() {
            return this.value;
        }
    }

    @Immutable
    static final class SoftReferencedFieldMap {
        private static final long CBOR_MAX_COMPRESSION_RATIO = 5L;
        private static final CborFactory CBOR_FACTORY;
        private String jsonObjectStringRepresentation;
        private byte[] cborObjectRepresentation;
        private int hashCode;
        private SoftReference<Map<String, JsonField>> fieldsReference;

        private SoftReferencedFieldMap(Map<String, JsonField> jsonFieldMap, @Nullable String stringRepresentation, @Nullable byte[] cborObjectRepresentation) {
            Objects.requireNonNull(jsonFieldMap, "The fields of JSON object must not be null!");
            this.fieldsReference = new SoftReference<Map<String, JsonField>>(Collections.unmodifiableMap(new LinkedHashMap<String, JsonField>(jsonFieldMap)));
            this.jsonObjectStringRepresentation = stringRepresentation;
            this.cborObjectRepresentation = cborObjectRepresentation;
            if (this.jsonObjectStringRepresentation == null && cborObjectRepresentation == null) {
                if (CBOR_FACTORY.isCborAvailable()) {
                    try {
                        this.cborObjectRepresentation = CBOR_FACTORY.createCborRepresentation(jsonFieldMap, this.guessSerializedSize());
                    }
                    catch (IOException e) {
                        assert (false);
                        this.jsonObjectStringRepresentation = this.createStringRepresentation(jsonFieldMap);
                    }
                } else {
                    this.jsonObjectStringRepresentation = this.createStringRepresentation(jsonFieldMap);
                }
            }
            this.hashCode = 0;
        }

        static SoftReferencedFieldMap empty() {
            return SoftReferencedFieldMap.of(Collections.emptyMap(), "{}", new byte[]{-96});
        }

        static SoftReferencedFieldMap of(Map<String, JsonField> fieldMap) {
            return new SoftReferencedFieldMap(fieldMap, null, null);
        }

        static SoftReferencedFieldMap of(Map<String, JsonField> jsonFieldMap, @Nullable String stringRepresentation) {
            return new SoftReferencedFieldMap(jsonFieldMap, stringRepresentation, null);
        }

        static SoftReferencedFieldMap of(Map<String, JsonField> jsonFieldMap, @Nullable byte[] cborObjectRepresentation) {
            return new SoftReferencedFieldMap(jsonFieldMap, null, cborObjectRepresentation);
        }

        static SoftReferencedFieldMap of(Map<String, JsonField> jsonFieldMap, @Nullable String stringRepresentation, @Nullable byte[] cborObjectRepresentation) {
            return new SoftReferencedFieldMap(jsonFieldMap, stringRepresentation, cborObjectRepresentation);
        }

        private String createStringRepresentation(Map<String, JsonField> jsonFieldMap) {
            StringBuilder stringBuilder = new StringBuilder(this.guessSerializedSize());
            stringBuilder.append('{');
            String delimiter = "";
            for (JsonField jsonField : jsonFieldMap.values()) {
                stringBuilder.append(delimiter);
                stringBuilder.append(jsonField);
                delimiter = ",";
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        int getSize() {
            return this.fields().size();
        }

        boolean isEmpty() {
            return this.fields().isEmpty();
        }

        boolean containsKey(String key) {
            return this.fields().containsKey(key);
        }

        @Nullable
        JsonField getOrNull(String key) {
            return this.fields().get(key);
        }

        SoftReferencedFieldMap put(String key, JsonField value) {
            Map<String, JsonField> fieldsCopy = this.copyFields();
            fieldsCopy.put(key, value);
            return SoftReferencedFieldMap.of(fieldsCopy);
        }

        private Map<String, JsonField> copyFields() {
            return new LinkedHashMap<String, JsonField>(this.fields());
        }

        SoftReferencedFieldMap putAll(Iterable<JsonField> jsonFields) {
            Map<String, JsonField> fieldsCopy = this.copyFields();
            jsonFields.forEach(jsonField -> fieldsCopy.put(jsonField.getKeyName(), (JsonField)jsonField));
            return SoftReferencedFieldMap.of(fieldsCopy);
        }

        SoftReferencedFieldMap remove(String key) {
            Map<String, JsonField> fieldsCopy = this.copyFields();
            fieldsCopy.remove(key);
            return SoftReferencedFieldMap.of(fieldsCopy);
        }

        Stream<JsonField> getStream() {
            return this.fields().values().stream();
        }

        Iterator<JsonField> getIterator() {
            return this.fields().values().iterator();
        }

        private Map<String, JsonField> fields() {
            Map<String, JsonField> result = this.fieldsReference.get();
            if (null == result) {
                result = this.recoverFields();
                this.fieldsReference = new SoftReference<Map<String, JsonField>>(result);
            }
            return result;
        }

        private Map<String, JsonField> recoverFields() {
            if (CBOR_FACTORY.isCborAvailable() && this.cborObjectRepresentation != null) {
                return SoftReferencedFieldMap.parseToMap(this.cborObjectRepresentation);
            }
            if (this.jsonObjectStringRepresentation != null) {
                return SoftReferencedFieldMap.parseToMap(this.jsonObjectStringRepresentation);
            }
            throw new IllegalStateException("Fatal cache miss on JsonObject");
        }

        private static Map<String, JsonField> parseToMap(String jsonObjectString) {
            FieldMapJsonHandler jsonHandler = new FieldMapJsonHandler();
            JsonValueParser.fromString(jsonHandler).accept(jsonObjectString);
            return jsonHandler.getValue();
        }

        private static Map<String, JsonField> parseToMap(byte[] cborObjectRepresentation) {
            JsonValue jsonObject = CBOR_FACTORY.readFrom(cborObjectRepresentation);
            LinkedHashMap<String, JsonField> map = new LinkedHashMap<String, JsonField>();
            for (JsonField jsonValue : jsonObject.asObject()) {
                map.put(jsonValue.getKey().toString(), jsonValue);
            }
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SoftReferencedFieldMap that = (SoftReferencedFieldMap)o;
            if (this.jsonObjectStringRepresentation != null && that.jsonObjectStringRepresentation != null) {
                if (this.jsonObjectStringRepresentation.equals(that.jsonObjectStringRepresentation)) {
                    return true;
                }
                if (this.jsonObjectStringRepresentation.length() == that.jsonObjectStringRepresentation.length()) {
                    return Objects.equals(this.fields(), that.fields());
                }
                return false;
            }
            if (this.cborObjectRepresentation != null && that.cborObjectRepresentation != null && Arrays.equals(this.cborObjectRepresentation, that.cborObjectRepresentation)) {
                return true;
            }
            return Objects.equals(this.fields(), that.fields());
        }

        public int hashCode() {
            int result = this.hashCode;
            if (0 == result) {
                this.hashCode = result = this.fields().hashCode();
            }
            return result;
        }

        String asJsonObjectString() {
            if (this.jsonObjectStringRepresentation == null) {
                this.jsonObjectStringRepresentation = this.createStringRepresentation(this.fields());
            }
            return this.jsonObjectStringRepresentation;
        }

        void writeValue(SerializationContext serializationContext) throws IOException {
            if (CBOR_FACTORY.isCborAvailable() && this.cborObjectRepresentation == null) {
                this.cborObjectRepresentation = CBOR_FACTORY.createCborRepresentation(this.fields(), this.guessSerializedSize());
            }
            serializationContext.writeCachedElement(this.cborObjectRepresentation);
        }

        private int guessSerializedSize() {
            if (this.jsonObjectStringRepresentation != null) {
                return this.jsonObjectStringRepresentation.length();
            }
            if (this.cborObjectRepresentation != null) {
                return this.cborObjectRepresentation.length;
            }
            return 512;
        }

        public long upperBoundForStringSize() {
            if (this.jsonObjectStringRepresentation != null) {
                return this.jsonObjectStringRepresentation.length();
            }
            if (this.cborObjectRepresentation != null) {
                return (long)this.cborObjectRepresentation.length * 5L;
            }
            assert (false);
            return Long.MAX_VALUE;
        }

        static {
            ServiceLoader<CborFactory> sl = ServiceLoader.load(CborFactory.class);
            CBOR_FACTORY = StreamSupport.stream(sl.spliterator(), false).findFirst().orElseGet(NoopCborFactory::new);
        }
    }
}

