/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.ImmutableJsonObject;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;

@NotThreadSafe
final class ImmutableJsonObjectBuilder
implements JsonObjectBuilder {
    private static final JsonKey ROOT_KEY = JsonFactory.newKey("/");
    private final Map<String, JsonField> fields = new LinkedHashMap<String, JsonField>();

    private ImmutableJsonObjectBuilder() {
    }

    public static ImmutableJsonObjectBuilder newInstance() {
        return new ImmutableJsonObjectBuilder();
    }

    @Override
    public ImmutableJsonObjectBuilder set(CharSequence key, int value, Predicate<JsonField> predicate) {
        return this.set(key, JsonFactory.newValue(value), (Predicate)predicate);
    }

    @Override
    public ImmutableJsonObjectBuilder set(CharSequence key, long value, Predicate<JsonField> predicate) {
        return this.set(key, JsonFactory.newValue(value), (Predicate)predicate);
    }

    @Override
    public ImmutableJsonObjectBuilder set(CharSequence key, double value, Predicate<JsonField> predicate) {
        return this.set(key, JsonFactory.newValue(value), (Predicate)predicate);
    }

    @Override
    public ImmutableJsonObjectBuilder set(CharSequence key, boolean value, Predicate<JsonField> predicate) {
        return this.set(key, JsonFactory.newValue(value), (Predicate)predicate);
    }

    @Override
    public ImmutableJsonObjectBuilder set(CharSequence key, @Nullable String value, Predicate<JsonField> predicate) {
        return this.set(key, JsonFactory.newValue(value), (Predicate)predicate);
    }

    @Override
    public ImmutableJsonObjectBuilder set(CharSequence key, JsonValue value, Predicate<JsonField> predicate) {
        JsonPointer pointer = JsonFactory.getNonEmptyPointer(key);
        ImmutableJsonObjectBuilder.checkValue(value);
        ImmutableJsonObjectBuilder.checkPredicate(predicate);
        pointer.getLeaf().map(leafKey -> JsonFactory.newField(leafKey, value)).filter(predicate).ifPresent(jsonField -> ImmutableJsonObjectBuilder.setFieldInHierarchy(this, pointer, jsonField));
        return this;
    }

    @Override
    public <T> JsonObjectBuilder set(JsonFieldDefinition<T> fieldDefinition, @Nullable T value, Predicate<JsonField> predicate) {
        Objects.requireNonNull(fieldDefinition, "The definition of the JSON field to set the value for must not be null!");
        ImmutableJsonObjectBuilder.checkPredicate(predicate);
        JsonPointer pointer = fieldDefinition.getPointer();
        pointer.getLeaf().map(leafKey -> JsonFactory.newField(leafKey, JsonFactory.getAppropriateValue(value), fieldDefinition)).filter(predicate).ifPresent(jsonField -> ImmutableJsonObjectBuilder.setFieldInHierarchy(this, pointer, jsonField));
        return this;
    }

    private static void checkValue(Object value) {
        Objects.requireNonNull(value, "The value must not be null!");
    }

    private static void checkPredicate(Predicate<JsonField> predicate) {
        Objects.requireNonNull(predicate, "The predicate must not be null!");
    }

    private static JsonObjectBuilder setFieldInHierarchy(ImmutableJsonObjectBuilder target, JsonPointer pointer, JsonField field) {
        JsonValue rootValue;
        if (1 >= pointer.getLevelCount()) {
            return target.set(field);
        }
        JsonKey rootKey = pointer.getRoot().orElse(ROOT_KEY);
        ImmutableJsonObjectBuilder newTarget = ImmutableJsonObjectBuilder.newInstance();
        JsonField rootJsonField = target.fields.get(rootKey.toString());
        if (null != rootJsonField && (rootValue = rootJsonField.getValue()).isObject() && !rootValue.isNull()) {
            newTarget.setAll((Iterable)rootValue.asObject());
        }
        JsonObject jsonObject = ImmutableJsonObjectBuilder.setFieldInHierarchy(newTarget, pointer.nextLevel(), field).build();
        return target.set((CharSequence)rootKey, jsonObject);
    }

    @Override
    public ImmutableJsonObjectBuilder set(JsonField field, Predicate<JsonField> predicate) {
        Objects.requireNonNull(field, "The field to be set must not be null!");
        if (predicate.test(field)) {
            this.fields.put(field.getKeyName(), field);
        }
        return this;
    }

    @Override
    public ImmutableJsonObjectBuilder remove(CharSequence key) {
        return this.remove(JsonFactory.newPointer(key));
    }

    private ImmutableJsonObjectBuilder remove(JsonPointer pointer) {
        pointer.getRoot().map(Object::toString).map(this.fields::get).ifPresent(jsonField -> {
            JsonValue rootValue = jsonField.getValue();
            JsonPointer nextPointerLevel = pointer.nextLevel();
            if (rootValue.isObject() && !nextPointerLevel.isEmpty()) {
                JsonObject rootObject = rootValue.asObject();
                rootObject = rootObject.remove(nextPointerLevel);
                this.set(JsonFactory.newField(jsonField.getKey(), rootObject, jsonField.getDefinition().orElse(null)));
            } else {
                this.fields.remove(jsonField.getKeyName());
            }
        });
        return this;
    }

    @Override
    public ImmutableJsonObjectBuilder remove(JsonFieldDefinition fieldDefinition) {
        Objects.requireNonNull(fieldDefinition, "The field definition must not be null!");
        return this.remove(fieldDefinition.getPointer());
    }

    @Override
    public ImmutableJsonObjectBuilder setAll(Iterable<JsonField> fields, Predicate<JsonField> predicate) {
        Objects.requireNonNull(fields, "The JSON fields to be set must not be null!");
        ImmutableJsonObjectBuilder.checkPredicate(predicate);
        StreamSupport.stream(fields.spliterator(), false).filter(field -> !field.getDefinition().isPresent() || predicate.test((JsonField)field)).forEach(fieldToBeSet -> this.fields.put(fieldToBeSet.getKeyName(), (JsonField)fieldToBeSet));
        return this;
    }

    @Override
    public ImmutableJsonObjectBuilder setAll(Iterable<JsonField> fields) {
        Objects.requireNonNull(fields, "The JSON fields to be set must not be null!");
        for (JsonField jsonField : fields) {
            this.fields.put(jsonField.getKeyName(), jsonField);
        }
        return this;
    }

    @Override
    public ImmutableJsonObjectBuilder removeAll() {
        this.fields.clear();
        return this;
    }

    @Override
    public Iterator<JsonField> iterator() {
        return this.fields.values().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    @Override
    public int getSize() {
        return this.fields.size();
    }

    @Override
    public Stream<JsonField> stream() {
        return this.fields.values().stream();
    }

    @Override
    public JsonObject build() {
        return ImmutableJsonObject.of(this.fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonObjectBuilder that = (ImmutableJsonObjectBuilder)o;
        return Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [fields=" + this.fields.values() + "]";
    }
}

