/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.AbstractJsonValue;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonNull;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class ImmutableJsonObjectNull
extends AbstractJsonValue
implements JsonObject,
JsonNull {
    @Nullable
    private static ImmutableJsonObjectNull instance = null;

    private ImmutableJsonObjectNull() {
    }

    public static ImmutableJsonObjectNull getInstance() {
        ImmutableJsonObjectNull result = instance;
        if (null == result) {
            instance = result = new ImmutableJsonObjectNull();
        }
        return result;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public ImmutableJsonObjectNull asObject() {
        return this;
    }

    @Override
    public ImmutableJsonObjectNull setValue(CharSequence key, int value) {
        return this;
    }

    @Override
    public ImmutableJsonObjectNull setValue(CharSequence key, long value) {
        return this;
    }

    @Override
    public ImmutableJsonObjectNull setValue(CharSequence key, double value) {
        return this;
    }

    @Override
    public ImmutableJsonObjectNull setValue(CharSequence key, boolean value) {
        return this;
    }

    @Override
    public ImmutableJsonObjectNull setValue(CharSequence key, String value) {
        return this;
    }

    @Override
    public ImmutableJsonObjectNull setValue(CharSequence key, JsonValue value) {
        return this;
    }

    @Override
    public <T> ImmutableJsonObjectNull set(JsonFieldDefinition<T> fieldDefinition, @Nullable T value) {
        return this;
    }

    @Override
    public ImmutableJsonObjectNull set(JsonField field) {
        return this;
    }

    @Override
    public ImmutableJsonObjectNull setAll(Iterable<JsonField> jsonFields) {
        return this;
    }

    @Override
    public boolean contains(CharSequence key) {
        return false;
    }

    @Override
    public ImmutableJsonObjectNull get(JsonPointer pointer) {
        return this;
    }

    @Override
    public ImmutableJsonObjectNull get(JsonFieldDefinition fieldDefinition) {
        return this;
    }

    @Override
    public Optional<JsonValue> getValue(CharSequence key) {
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> getValue(JsonFieldDefinition<T> fieldDefinition) {
        return Optional.empty();
    }

    @Override
    public <T> T getValueOrThrow(JsonFieldDefinition<T> fieldDefinition) {
        throw (JsonMissingFieldException)JsonMissingFieldException.newBuilder().fieldName(fieldDefinition.getPointer()).build();
    }

    @Override
    public ImmutableJsonObjectNull get(JsonFieldSelector fieldSelector) {
        return this;
    }

    @Override
    public ImmutableJsonObjectNull remove(CharSequence key) {
        return this;
    }

    @Override
    public List<JsonKey> getKeys() {
        return Collections.emptyList();
    }

    @Override
    public Optional<JsonField> getField(CharSequence key) {
        return Optional.empty();
    }

    @Override
    public Iterator<JsonField> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public Stream<JsonField> stream() {
        return Stream.empty();
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int getSize() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof JsonNull;
    }

    public int hashCode() {
        return JsonNull.class.hashCode();
    }

    @Override
    public String toString() {
        return JsonFactory.nullLiteral().toString();
    }
}

