/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPatch;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class ImmutableJsonPatch
implements JsonPatch {
    private final JsonPatch.Operation operation;
    private final JsonPointer path;
    @Nullable
    private final JsonValue value;

    private ImmutableJsonPatch(JsonPatch.Operation operation, JsonPointer path, @Nullable JsonValue value) {
        this.operation = Objects.requireNonNull(operation, "The operation of the JSON Patch must not be null!");
        this.path = Objects.requireNonNull(path, "The path of the JSON Patch must not be null!");
        this.value = value;
    }

    public static ImmutableJsonPatch newInstance(JsonPatch.Operation operation, JsonPointer path, @Nullable JsonValue value) {
        return new ImmutableJsonPatch(operation, path, value);
    }

    public static ImmutableJsonPatch fromJson(String jsonString) {
        Objects.requireNonNull(jsonString, "The string representation of the JSON Patch to be created must not be null!");
        if (jsonString.isEmpty()) {
            throw new IllegalArgumentException("The string representation of the JSON Patch to be created must not be empty!");
        }
        JsonObject jsonObject = JsonFactory.newObject(jsonString);
        String operationName = jsonObject.getValueOrThrow(JsonPatch.JsonFields.OPERATION);
        JsonPatch.Operation operation = JsonPatch.Operation.fromString(operationName).orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("Operation <{0}> is unknown!", operationName)));
        JsonPointer path = JsonFactory.newPointer(jsonObject.getValueOrThrow(JsonPatch.JsonFields.PATH));
        JsonValue value = jsonObject.getValue(JsonPatch.JsonFields.VALUE).orElse(null);
        return new ImmutableJsonPatch(operation, path, value);
    }

    @Override
    public JsonPatch.Operation getOperation() {
        return this.operation;
    }

    @Override
    public JsonPointer getPath() {
        return this.path;
    }

    @Override
    public Optional<JsonValue> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public JsonObject toJson() {
        JsonObjectBuilder builder = JsonFactory.newObjectBuilder().set(JsonPatch.JsonFields.OPERATION, this.operation.toString()).set(JsonPatch.JsonFields.PATH, this.path.toString());
        if (null != this.value) {
            builder.set(JsonPatch.JsonFields.VALUE, this.value);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonPatch that = (ImmutableJsonPatch)o;
        return this.operation == that.operation && Objects.equals(this.path, that.path) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.path, this.value});
    }

    @Override
    public String toString() {
        return this.toJson().toString();
    }
}

