/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonPointerInvalidException;

@Immutable
final class ImmutableJsonPointer
implements JsonPointer {
    private static final Pattern DOUBLE_SLASH_PATTERN = Pattern.compile("//");
    private static final String SLASH = "/";
    private static final String SLASH_REGEX = "/(?!/)";
    private static final Pattern SINGLE_SLASH_REGEX_PATTERN = Pattern.compile("/(?!/)");
    private static final Pattern ESCAPED_TILDE_PATTERN = Pattern.compile("~0");
    private static final Pattern DECODED_TILDE_PATTERN = Pattern.compile("~");
    private static final ImmutableJsonPointer EMPTY = new ImmutableJsonPointer(Collections.emptyList());
    private final List<JsonKey> jsonKeyHierarchy;

    private ImmutableJsonPointer(List<JsonKey> theJsonKeys) {
        this.jsonKeyHierarchy = Collections.unmodifiableList(new ArrayList<JsonKey>(theJsonKeys));
    }

    public static ImmutableJsonPointer empty() {
        return EMPTY;
    }

    public static JsonPointer ofParsed(CharSequence slashDelimitedCharSequence) {
        JsonPointer result;
        Objects.requireNonNull(slashDelimitedCharSequence, "The JSON pointer character sequence must not be null!");
        if (JsonPointer.class.isAssignableFrom(slashDelimitedCharSequence.getClass())) {
            result = (JsonPointer)slashDelimitedCharSequence;
        } else if (JsonKey.class.isAssignableFrom(slashDelimitedCharSequence.getClass())) {
            result = ImmutableJsonPointer.newInstance(Collections.singletonList((JsonKey)slashDelimitedCharSequence));
        } else if (0 == slashDelimitedCharSequence.length()) {
            result = ImmutableJsonPointer.empty();
        } else {
            if (DOUBLE_SLASH_PATTERN.matcher(slashDelimitedCharSequence).find()) {
                throw JsonPointerInvalidException.newBuilderForConsecutiveSlashes(slashDelimitedCharSequence).build();
            }
            List<JsonKey> jsonKeys = Stream.of(SINGLE_SLASH_REGEX_PATTERN.split(slashDelimitedCharSequence)).filter(keyName -> !keyName.isEmpty()).map(ImmutableJsonPointer::decodeTilde).map(JsonFactory::newKey).collect(Collectors.toList());
            result = ImmutableJsonPointer.newInstance(jsonKeys);
        }
        return result;
    }

    private static String decodeTilde(CharSequence keyString) {
        Matcher matcher = ESCAPED_TILDE_PATTERN.matcher(keyString);
        return matcher.replaceAll(DECODED_TILDE_PATTERN.toString());
    }

    private static ImmutableJsonPointer newInstance(List<JsonKey> jsonKeyHierarchy) {
        return new ImmutableJsonPointer(jsonKeyHierarchy);
    }

    public static ImmutableJsonPointer of(JsonKey rootLevel, JsonKey ... subLevels) {
        ImmutableJsonPointer.checkRootLevel(rootLevel);
        Objects.requireNonNull(subLevels, "The sub levels must not be null! If the JSON pointer does not require sub levels, just omit this argument.");
        ArrayList<JsonKey> keyHierarchy = new ArrayList<JsonKey>(1 + subLevels.length);
        keyHierarchy.add(rootLevel);
        Collections.addAll(keyHierarchy, subLevels);
        ImmutableJsonPointer result = ImmutableJsonPointer.newInstance(keyHierarchy);
        return result;
    }

    private static void checkRootLevel(JsonKey rootLevel) {
        Objects.requireNonNull(rootLevel, "The root level of the JSON pointer must not be null!");
    }

    static ImmutableJsonPointer of(JsonKey rootLevel, JsonPointer subPointer) {
        ImmutableJsonPointer.checkRootLevel(rootLevel);
        ImmutableJsonPointer.checkSubPointer(subPointer);
        ArrayList<JsonKey> keyHierarchy = new ArrayList<JsonKey>(1 + subPointer.getLevelCount());
        keyHierarchy.add(rootLevel);
        subPointer.forEach(keyHierarchy::add);
        ImmutableJsonPointer result = ImmutableJsonPointer.newInstance(keyHierarchy);
        return result;
    }

    private static void checkSubPointer(Object subPointer) {
        Objects.requireNonNull(subPointer, "The sub sub pointer to be appended must not be null!");
    }

    @Override
    public ImmutableJsonPointer addLeaf(JsonKey key) {
        Objects.requireNonNull(key, "The level to be added must not be null!");
        ArrayList<JsonKey> newJsonKeys = new ArrayList<JsonKey>(this.jsonKeyHierarchy);
        newJsonKeys.add(key);
        return ImmutableJsonPointer.newInstance(newJsonKeys);
    }

    @Override
    public ImmutableJsonPointer append(JsonPointer subPointer) {
        ImmutableJsonPointer result;
        ImmutableJsonPointer.checkSubPointer(subPointer);
        if (subPointer.isEmpty()) {
            result = this;
        } else {
            ArrayList<JsonKey> newJsonKeys = new ArrayList<JsonKey>(this.jsonKeyHierarchy);
            subPointer.forEach(newJsonKeys::add);
            result = ImmutableJsonPointer.newInstance(newJsonKeys);
        }
        return result;
    }

    @Override
    public int getLevelCount() {
        return this.jsonKeyHierarchy.size();
    }

    @Override
    public boolean isEmpty() {
        return this.jsonKeyHierarchy.isEmpty();
    }

    @Override
    public Optional<JsonKey> get(int level) {
        try {
            return Optional.of(this.jsonKeyHierarchy.get(level));
        }
        catch (IndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<JsonKey> getRoot() {
        return this.get(0);
    }

    @Override
    public Optional<JsonKey> getLeaf() {
        return this.get(this.getLevelCount() - 1);
    }

    @Override
    public Optional<JsonPointer> getSubPointer(int level) {
        ArrayList<JsonKey> jsonKeysCopy = new ArrayList<JsonKey>(this.jsonKeyHierarchy);
        try {
            List<JsonKey> subList = jsonKeysCopy.subList(level, jsonKeysCopy.size());
            return Optional.of(ImmutableJsonPointer.newInstance(subList));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<JsonPointer> getPrefixPointer(int level) {
        ArrayList<JsonKey> jsonKeysCopy = new ArrayList<JsonKey>(this.jsonKeyHierarchy);
        try {
            List<JsonKey> subList = jsonKeysCopy.subList(0, level);
            return Optional.of(ImmutableJsonPointer.newInstance(subList));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }

    @Override
    public ImmutableJsonPointer cutLeaf() {
        ImmutableJsonPointer result = this;
        if (!this.isEmpty()) {
            List<JsonKey> subList = this.jsonKeyHierarchy.subList(0, this.getLevelCount() - 1);
            result = ImmutableJsonPointer.newInstance(subList);
        }
        return result;
    }

    @Override
    public JsonPointer nextLevel() {
        return this.getSubPointer(1).orElse(this);
    }

    @Override
    public JsonFieldSelector toFieldSelector() {
        return JsonFactory.newFieldSelector(this, new JsonPointer[0]);
    }

    @Override
    public Iterator<JsonKey> iterator() {
        return new ArrayList<JsonKey>(this.jsonKeyHierarchy).iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonPointer jsonKeys = (ImmutableJsonPointer)o;
        return Objects.equals(this.jsonKeyHierarchy, jsonKeys.jsonKeyHierarchy);
    }

    public int hashCode() {
        return Objects.hash(this.jsonKeyHierarchy);
    }

    @Override
    public int length() {
        String s = this.toString();
        return s.length();
    }

    @Override
    public char charAt(int index) {
        String s = this.toString();
        return s.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        String s = this.toString();
        return s.subSequence(start, end);
    }

    @Override
    public String toString() {
        String stringRepresentation = this.jsonKeyHierarchy.isEmpty() ? SLASH : SLASH + this.jsonKeyHierarchy.stream().map(ImmutableJsonPointer::escapeTilde).collect(Collectors.joining(SLASH));
        return stringRepresentation;
    }

    private static String escapeTilde(JsonKey jsonKey) {
        String keyString = jsonKey.toString();
        Matcher matcher = DECODED_TILDE_PATTERN.matcher(keyString);
        return matcher.replaceAll(ESCAPED_TILDE_PATTERN.toString());
    }
}

