/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.AbstractJsonValue;
import org.eclipse.ditto.json.JavaStringToEscapedJsonString;
import org.eclipse.ditto.json.SerializationContext;

@Immutable
final class ImmutableJsonString
extends AbstractJsonValue {
    private static final long MAX_CHAR_ESCAPE_SEQUENCE_LENGTH = 6L;
    private static final long NUM_ENCLOSING_QUOTES = 2L;
    private final String value;
    @Nullable
    private String stringRepresentation;

    private ImmutableJsonString(String jsonString) {
        this.value = jsonString;
        this.stringRepresentation = null;
    }

    public static ImmutableJsonString of(String string) {
        return new ImmutableJsonString(Objects.requireNonNull(string, "The string value must not be null!"));
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String asString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonString that = (ImmutableJsonString)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        String result = this.stringRepresentation;
        if (null == result) {
            this.stringRepresentation = result = this.createStringRepresentation();
        }
        return result;
    }

    @Override
    public void writeValue(SerializationContext serializationContext) throws IOException {
        serializationContext.writeString(this.value);
    }

    @Override
    public long getUpperBoundForStringSize() {
        if (this.stringRepresentation != null) {
            return this.stringRepresentation.length();
        }
        return (long)this.value.length() * 6L + 2L;
    }

    private String createStringRepresentation() {
        JavaStringToEscapedJsonString javaStringToEscapedJsonString = JavaStringToEscapedJsonString.getInstance();
        return javaStringToEscapedJsonString.apply(this.value);
    }
}

