/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonCharEscaper;

@Immutable
final class JavaStringToEscapedJsonString
implements UnaryOperator<String> {
    private static final JavaStringToEscapedJsonString INSTANCE = new JavaStringToEscapedJsonString(JsonCharEscaper.getInstance());
    private static final char QUOTE = '\"';
    private final Function<Integer, String> jsonCharEscaper;

    private JavaStringToEscapedJsonString(Function<Integer, String> theJsonCharEscaper) {
        this.jsonCharEscaper = theJsonCharEscaper;
    }

    public static JavaStringToEscapedJsonString getInstance() {
        return INSTANCE;
    }

    @Override
    public String apply(String javaString) {
        Objects.requireNonNull(javaString, "The Java String to be converted must not be null");
        StringBuilder stringBuilder = new StringBuilder(javaString.length() + 2);
        stringBuilder.append('\"');
        stringBuilder.append(javaString);
        int i = 1;
        for (char c : javaString.toCharArray()) {
            String replacement = this.jsonCharEscaper.apply(Integer.valueOf(c));
            if (null != replacement) {
                stringBuilder.replace(i, i + 1, replacement);
                i += replacement.length();
                continue;
            }
            ++i;
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }
}

