/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.AbstractJsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class JavaValueFieldDefinition<T>
extends AbstractJsonFieldDefinition<T> {
    private JavaValueFieldDefinition(CharSequence pointer, Class<T> valueType, Function<JsonValue, Boolean> checkJavaTypeFunction, Function<JsonValue, T> mappingFunction, JsonFieldMarker ... markers) {
        super(pointer, valueType, checkJavaTypeFunction, mappingFunction, markers);
    }

    public static <T> JavaValueFieldDefinition<T> newInstance(CharSequence pointer, Class<T> valueType, Function<JsonValue, Boolean> checkJavaTypeFunction, Function<JsonValue, T> mappingFunction, JsonFieldMarker ... markers) {
        return new JavaValueFieldDefinition<T>(pointer, valueType, checkJavaTypeFunction, mappingFunction, markers);
    }

    @Override
    @Nullable
    protected T getAsJavaType(JsonValue jsonValue, Function<JsonValue, T> mappingFunction) {
        if (jsonValue.isNull()) {
            return null;
        }
        return mappingFunction.apply(jsonValue);
    }
}

