/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonArrayBuilder;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.JsonValueContainer;

public interface JsonArray
extends JsonValue,
JsonValueContainer<JsonValue> {
    public static JsonArray of(String jsonArrayString) {
        return JsonFactory.newArray(jsonArrayString);
    }

    public static JsonArray empty() {
        return JsonFactory.newArray();
    }

    public static <T> JsonArray of(@Nullable T value, T ... furtherValues) {
        JsonArrayBuilder arrayBuilder = JsonArray.newBuilder();
        arrayBuilder.add(JsonFactory.getAppropriateValue(value), new JsonValue[0]);
        for (T furtherValue : furtherValues) {
            arrayBuilder.add(JsonFactory.getAppropriateValue(furtherValue), new JsonValue[0]);
        }
        return arrayBuilder.build();
    }

    public static <T> JsonArray of(Iterable<T> values) {
        Objects.requireNonNull(values, "The values of the array must not be null!");
        if (values instanceof JsonValue) {
            return JsonFactory.newArrayBuilder().add((JsonValue)((Object)values), new JsonValue[0]).build();
        }
        return StreamSupport.stream(values.spliterator(), false).map(JsonFactory::getAppropriateValue).collect(JsonCollectors.valuesToArray());
    }

    public static JsonArrayBuilder newBuilder() {
        return JsonFactory.newArrayBuilder();
    }

    default public JsonArrayBuilder toBuilder() {
        return JsonFactory.newArrayBuilder(this);
    }

    public JsonArray add(int var1, int ... var2);

    public JsonArray add(long var1, long ... var3);

    public JsonArray add(double var1, double ... var3);

    public JsonArray add(boolean var1, boolean ... var2);

    public JsonArray add(String var1, String ... var2);

    public JsonArray add(JsonValue var1, JsonValue ... var2);

    public Optional<JsonValue> get(int var1);

    public boolean contains(JsonValue var1);

    public int indexOf(JsonValue var1);
}

