/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class JsonCharEscaper
implements Function<Integer, String> {
    private static final JsonCharEscaper INSTANCE = new JsonCharEscaper();
    private static final char LAST_CONTROL_CHARACTER = '\u001f';
    private static final char LAST_ASCII = '\u007f';
    private static final String[] ESCAPE_TABLE = JsonCharEscaper.createEscapeTable();

    private JsonCharEscaper() {
    }

    public static JsonCharEscaper getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public String apply(Integer i) {
        if (0 <= i && i < ESCAPE_TABLE.length) {
            return ESCAPE_TABLE[i];
        }
        return null;
    }

    private static String[] createEscapeTable() {
        String[] table = new String[128];
        for (int i = 0; i <= 31; ++i) {
            table[i] = JsonCharEscaper.escapeAsUnicode(i);
        }
        for (int c = 32; c < table.length; c = (int)((char)(c + 1))) {
            table[c] = null;
        }
        table[8] = "\\b";
        table[12] = "\\f";
        table[10] = "\\n";
        table[13] = "\\r";
        table[9] = "\\t";
        table[34] = "\\\"";
        table[92] = "\\\\";
        return table;
    }

    private static String escapeAsUnicode(int i) {
        return String.format("\\u%04X", i);
    }
}

