/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.ImmutableJsonArray;
import org.eclipse.ditto.json.ImmutableJsonArrayBuilder;
import org.eclipse.ditto.json.ImmutableJsonArrayNull;
import org.eclipse.ditto.json.ImmutableJsonBoolean;
import org.eclipse.ditto.json.ImmutableJsonDouble;
import org.eclipse.ditto.json.ImmutableJsonField;
import org.eclipse.ditto.json.ImmutableJsonFieldSelector;
import org.eclipse.ditto.json.ImmutableJsonFieldSelectorBuilder;
import org.eclipse.ditto.json.ImmutableJsonFieldSelectorFactory;
import org.eclipse.ditto.json.ImmutableJsonInt;
import org.eclipse.ditto.json.ImmutableJsonKey;
import org.eclipse.ditto.json.ImmutableJsonLong;
import org.eclipse.ditto.json.ImmutableJsonNull;
import org.eclipse.ditto.json.ImmutableJsonObject;
import org.eclipse.ditto.json.ImmutableJsonObjectBuilder;
import org.eclipse.ditto.json.ImmutableJsonObjectNull;
import org.eclipse.ditto.json.ImmutableJsonParseOptionsBuilder;
import org.eclipse.ditto.json.ImmutableJsonPatch;
import org.eclipse.ditto.json.ImmutableJsonPointer;
import org.eclipse.ditto.json.ImmutableJsonString;
import org.eclipse.ditto.json.JavaValueFieldDefinition;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonArrayBuilder;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonFieldSelectorBuilder;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonObjectMerger;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonParseOptions;
import org.eclipse.ditto.json.JsonParseOptionsBuilder;
import org.eclipse.ditto.json.JsonPatch;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.JsonValueFieldDefinition;
import org.eclipse.ditto.json.JsonValueMerger;
import org.eclipse.ditto.json.JsonValueParser;

@Immutable
public final class JsonFactory {
    private static final String NULL_STRING = "null";
    private static final byte[] NULL_DATA = "null".getBytes(StandardCharsets.UTF_8);

    private JsonFactory() {
        throw new AssertionError();
    }

    public static JsonKey newKey(CharSequence keyValue) {
        return ImmutableJsonKey.of(keyValue);
    }

    public static JsonValue nullLiteral() {
        return ImmutableJsonNull.getInstance();
    }

    static <T> JsonValue getAppropriateValue(@Nullable T value) {
        JsonValue result = null == value ? JsonFactory.nullLiteral() : (value instanceof JsonValue ? (JsonValue)value : (value instanceof Boolean ? JsonFactory.newValue((Boolean)value) : (value instanceof Integer ? JsonFactory.newValue((Integer)value) : (value instanceof Long ? JsonFactory.newValue((Long)value) : (value instanceof Double ? JsonFactory.newValue((Double)value) : (value instanceof CharSequence ? JsonFactory.newValue(String.valueOf(value)) : JsonValueParser.fromString().apply(String.valueOf(value))))))));
        return result;
    }

    public static JsonValue newValue(boolean value) {
        return value ? ImmutableJsonBoolean.TRUE : ImmutableJsonBoolean.FALSE;
    }

    public static JsonValue newValue(int value) {
        return ImmutableJsonInt.of(value);
    }

    public static JsonValue newValue(long value) {
        return ImmutableJsonLong.of(value);
    }

    public static JsonValue newValue(double value) {
        return ImmutableJsonDouble.of(value);
    }

    public static JsonValue newValue(@Nullable String jsonString) {
        JsonValue result = null != jsonString ? ImmutableJsonString.of(jsonString) : JsonFactory.nullLiteral();
        return result;
    }

    public static JsonValue readFrom(String jsonString) {
        Objects.requireNonNull(jsonString, "The JSON string to read from must not be null!");
        if (jsonString.isEmpty()) {
            throw new JsonParseException("The JSON string to read from must not be empty!");
        }
        return JsonValueParser.fromString().apply(jsonString);
    }

    public static JsonValue readFrom(Reader reader) {
        return JsonValueParser.fromReader().apply(reader);
    }

    public static JsonObjectBuilder newObjectBuilder() {
        return ImmutableJsonObjectBuilder.newInstance();
    }

    public static JsonObjectBuilder newObjectBuilder(Iterable<JsonField> jsonFields) {
        Objects.requireNonNull(jsonFields, "The initial JSON fields must not be null!");
        return JsonFactory.newObjectBuilder().setAll(jsonFields);
    }

    public static JsonObject newObject() {
        return ImmutableJsonObject.empty();
    }

    public static JsonObject newObject(String jsonString) {
        Objects.requireNonNull(jsonString, "The JSON string to create a JSON object from must not be null!");
        if (jsonString.isEmpty()) {
            throw new IllegalArgumentException("The JSON string to create a JSON object from must not be empty!");
        }
        if (JsonFactory.isJsonNullLiteralString(jsonString)) {
            return JsonFactory.nullObject();
        }
        JsonValue jsonValue = JsonValueParser.fromString().apply(jsonString);
        return JsonFactory.newObject(jsonValue);
    }

    public static JsonObject newObject(JsonValue jsonValue) {
        if (!jsonValue.isObject()) {
            String msgPattern = "<{0}> is not a valid JSON object!";
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("<{0}> is not a valid JSON object!", jsonValue.toString())).build();
        }
        return jsonValue.asObject();
    }

    public static JsonObject newObject(byte[] jsonData) {
        Objects.requireNonNull(jsonData, "The JSON data to create a JSON object from must not be null!");
        if (jsonData.length == 0) {
            throw new IllegalArgumentException("The JSON data to create a JSON object from must not be empty!");
        }
        if (JsonFactory.isJsonNullLiteralData(jsonData)) {
            return JsonFactory.nullObject();
        }
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(jsonData));
        JsonValue jsonValue = JsonValueParser.fromReader().apply(reader);
        if (!jsonValue.isObject()) {
            String msgPattern = "<{0}> is not a valid JSON object!";
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("<{0}> is not a valid JSON object!", jsonValue)).build();
        }
        return jsonValue.asObject();
    }

    private static boolean isJsonNullLiteralString(String s) {
        return NULL_STRING.equals(s);
    }

    private static boolean isJsonNullLiteralData(byte[] data) {
        return Arrays.equals(NULL_DATA, data);
    }

    public static JsonObject newObject(Map<JsonKey, JsonValue> fields) {
        LinkedHashMap<String, JsonField> jsonFields = new LinkedHashMap<String, JsonField>(fields.size());
        fields.forEach((jsonKey, jsonValue) -> jsonFields.put(jsonKey.toString(), JsonFactory.newField(jsonKey, jsonValue)));
        return ImmutableJsonObject.of(jsonFields);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonObject newObject(JsonPointer path, JsonValue value) {
        if (!path.isEmpty()) return JsonObject.newBuilder().set((CharSequence)path, value).build();
        if (!value.isObject()) throw new IllegalArgumentException("Value must be a JsonObject at root revel (empty path).");
        return value.asObject();
    }

    public static JsonObject newObject(Iterable<JsonField> jsonFields) {
        if (jsonFields instanceof JsonObject && ((JsonValue)((Object)jsonFields)).isNull()) {
            return JsonFactory.nullObject();
        }
        return JsonFactory.newObjectBuilder(jsonFields).build();
    }

    public static JsonObject newObject(JsonObject jsonObject1, JsonObject jsonObject2) {
        return JsonObjectMerger.mergeJsonObjects(jsonObject1, jsonObject2);
    }

    public static JsonValue mergeJsonValues(JsonValue jsonValue1, JsonValue jsonValue2) {
        return JsonValueMerger.mergeJsonValues(jsonValue1, jsonValue2);
    }

    public static JsonObject nullObject() {
        return ImmutableJsonObjectNull.getInstance();
    }

    public static JsonArrayBuilder newArrayBuilder() {
        return ImmutableJsonArrayBuilder.newInstance();
    }

    public static JsonArrayBuilder newArrayBuilder(Iterable<? extends JsonValue> values) {
        return JsonFactory.newArrayBuilder().addAll(values);
    }

    public static JsonArray newArray() {
        return ImmutableJsonArray.empty();
    }

    public static JsonArray newArray(String jsonString) {
        Objects.requireNonNull(jsonString, "The JSON string to create JSON array from must not be null!");
        if (jsonString.isEmpty()) {
            throw new IllegalArgumentException("The JSON string to create a JSON array from must not be empty!");
        }
        if (JsonFactory.isJsonNullLiteralString(jsonString)) {
            return JsonFactory.nullArray();
        }
        JsonValue jsonValue = JsonValueParser.fromString().apply(jsonString);
        if (!jsonValue.isArray()) {
            String msgPattern = "<{0}> is not a valid JSON array!";
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("<{0}> is not a valid JSON array!", jsonString)).build();
        }
        return jsonValue.asArray();
    }

    public static JsonArray nullArray() {
        return ImmutableJsonArrayNull.getInstance();
    }

    public static JsonField newField(JsonKey key, @Nullable JsonValue value) {
        return JsonFactory.newField(key, value, null);
    }

    public static JsonField newField(JsonKey key, @Nullable JsonValue value, @Nullable JsonFieldDefinition definition) {
        return ImmutableJsonField.newInstance(key, null != value ? value : JsonFactory.nullLiteral(), definition);
    }

    public static JsonPatch newPatch(JsonPatch.Operation operation, JsonPointer path, @Nullable JsonValue value) {
        return ImmutableJsonPatch.newInstance(operation, path, value);
    }

    public static JsonPatch newPatch(String jsonString) {
        return ImmutableJsonPatch.fromJson(jsonString);
    }

    public static JsonPointer emptyPointer() {
        return ImmutableJsonPointer.empty();
    }

    public static JsonPointer newPointer(JsonKey rootLevel, JsonKey ... subLevels) {
        return ImmutableJsonPointer.of(rootLevel, subLevels);
    }

    public static JsonPointer newPointer(CharSequence slashDelimitedCharSequence) {
        return ImmutableJsonPointer.ofParsed(slashDelimitedCharSequence);
    }

    public static JsonParseOptionsBuilder newParseOptionsBuilder() {
        return ImmutableJsonParseOptionsBuilder.newInstance();
    }

    public static JsonFieldSelector emptyFieldSelector() {
        return ImmutableJsonFieldSelector.empty();
    }

    public static JsonFieldSelector newFieldSelector(@Nullable String fieldSelectorString, JsonParseOptions options) {
        JsonFieldSelector result;
        if (null == fieldSelectorString || fieldSelectorString.isEmpty()) {
            result = ImmutableJsonFieldSelector.empty();
        } else {
            ImmutableJsonFieldSelectorFactory jsonFieldSelectorFactory = ImmutableJsonFieldSelectorFactory.newInstance(fieldSelectorString, options);
            result = jsonFieldSelectorFactory.newJsonFieldSelector();
        }
        return result;
    }

    public static JsonFieldSelector newFieldSelector(Iterable<JsonPointer> pointers) {
        Objects.requireNonNull(pointers, "In order to create a JSON field selector the JSON pointers must not be null!");
        return ImmutableJsonFieldSelector.of(pointers);
    }

    public static JsonFieldSelector newFieldSelector(JsonPointer pointer, JsonPointer ... furtherPointers) {
        Objects.requireNonNull(pointer, "The JSON pointer must not be null!");
        Objects.requireNonNull(furtherPointers, "The optional JSON keys must not be null!");
        LinkedHashSet<JsonPointer> jsonPointers = new LinkedHashSet<JsonPointer>(1 + furtherPointers.length);
        jsonPointers.add(pointer);
        Collections.addAll(jsonPointers, furtherPointers);
        return ImmutableJsonFieldSelector.of(jsonPointers);
    }

    public static JsonFieldSelector newFieldSelector(CharSequence pointerString, CharSequence ... furtherPointerStrings) {
        Objects.requireNonNull(pointerString, "The JSON pointer string must not be null!");
        Objects.requireNonNull(furtherPointerStrings, "The optional JSON keys must not be null!");
        LinkedHashSet<JsonPointer> jsonPointers = new LinkedHashSet<JsonPointer>(1 + furtherPointerStrings.length);
        jsonPointers.add(JsonFactory.newPointer(pointerString));
        for (CharSequence furtherPointerString : furtherPointerStrings) {
            jsonPointers.add(JsonFactory.newPointer(furtherPointerString));
        }
        return ImmutableJsonFieldSelector.of(jsonPointers);
    }

    @Nullable
    public static JsonFieldSelector parseJsonFieldSelector(@Nullable String jsonFieldSelectorString) {
        if (jsonFieldSelectorString == null) {
            return null;
        }
        String[] splitFields = jsonFieldSelectorString.split(",");
        if (splitFields.length < 1) {
            return null;
        }
        String firstField = splitFields[0];
        CharSequence[] otherFields = (String[])Arrays.stream(splitFields).skip(1L).toArray(String[]::new);
        return JsonFieldSelector.newInstance(firstField, otherFields);
    }

    public static JsonFieldSelector newFieldSelector(JsonFieldDefinition fieldDefinition, JsonFieldDefinition ... furtherFieldDefinitions) {
        Objects.requireNonNull(fieldDefinition, "The JSON field definition must not be null!");
        Objects.requireNonNull(furtherFieldDefinitions, "The optional JSON field definitions must not be null!");
        LinkedHashSet<JsonPointer> pointers = new LinkedHashSet<JsonPointer>(1 + furtherFieldDefinitions.length);
        pointers.add(fieldDefinition.getPointer());
        for (JsonFieldDefinition furtherFieldDefinition : furtherFieldDefinitions) {
            pointers.add(furtherFieldDefinition.getPointer());
        }
        return JsonFactory.newFieldSelector(pointers);
    }

    public static JsonFieldSelectorBuilder newFieldSelectorBuilder() {
        return ImmutableJsonFieldSelectorBuilder.newInstance();
    }

    public static JsonFieldDefinition<String> newStringFieldDefinition(CharSequence pointer, JsonFieldMarker ... markers) {
        return JavaValueFieldDefinition.newInstance(pointer, String.class, JsonValue::isString, JsonValue::asString, markers);
    }

    public static JsonFieldDefinition<Boolean> newBooleanFieldDefinition(CharSequence pointer, JsonFieldMarker ... markers) {
        return JavaValueFieldDefinition.newInstance(pointer, Boolean.class, JsonValue::isBoolean, JsonValue::asBoolean, markers);
    }

    public static JsonFieldDefinition<Integer> newIntFieldDefinition(CharSequence pointer, JsonFieldMarker ... markers) {
        return JavaValueFieldDefinition.newInstance(pointer, Integer.class, JsonValue::isNumber, JsonValue::asInt, markers);
    }

    public static JsonFieldDefinition<Long> newLongFieldDefinition(CharSequence pointer, JsonFieldMarker ... markers) {
        return JavaValueFieldDefinition.newInstance(pointer, Long.class, JsonValue::isNumber, JsonValue::asLong, markers);
    }

    public static JsonFieldDefinition<Double> newDoubleFieldDefinition(CharSequence pointer, JsonFieldMarker ... markers) {
        return JavaValueFieldDefinition.newInstance(pointer, Double.class, JsonValue::isNumber, JsonValue::asDouble, markers);
    }

    public static JsonFieldDefinition<JsonArray> newJsonArrayFieldDefinition(CharSequence pointer, JsonFieldMarker ... markers) {
        return JsonValueFieldDefinition.newInstance(pointer, JsonArray.class, JsonValue::isArray, JsonValue::asArray, markers);
    }

    public static JsonFieldDefinition<JsonObject> newJsonObjectFieldDefinition(CharSequence pointer, JsonFieldMarker ... markers) {
        return JsonValueFieldDefinition.newInstance(pointer, JsonObject.class, JsonValue::isObject, JsonValue::asObject, markers);
    }

    public static JsonFieldDefinition<JsonValue> newJsonValueFieldDefinition(CharSequence pointer, JsonFieldMarker ... markers) {
        return JsonValueFieldDefinition.newInstance(pointer, JsonValue.class, jsonValue -> true, Function.identity(), markers);
    }

    public static JsonArray createJsonArray(List<JsonValue> jsonValueList, @Nullable byte[] cborRepresentation) {
        return new ImmutableJsonArray(ImmutableJsonArray.SoftReferencedValueList.of(jsonValueList, cborRepresentation));
    }

    public static JsonObject createJsonObject(Map<String, JsonField> jsonFieldMap, @Nullable byte[] cborObjectRepresentation) {
        return new ImmutableJsonObject(ImmutableJsonObject.SoftReferencedFieldMap.of(jsonFieldMap, null, cborObjectRepresentation));
    }

    static JsonPointer getNonEmptyPointer(CharSequence keyOrPointer) {
        JsonPointer result;
        Objects.requireNonNull(keyOrPointer, "The key or pointer char sequence must not be null!");
        if (JsonFactory.isPointer(keyOrPointer)) {
            result = JsonFactory.newPointer(keyOrPointer);
        } else {
            JsonKey jsonKey = JsonFactory.newKey(keyOrPointer);
            result = jsonKey.asPointer();
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("The key or pointer must not be empty!");
        }
        return result;
    }

    private static boolean isPointer(@Nullable CharSequence charSequence) {
        return null != charSequence && !JsonKey.class.isAssignableFrom(charSequence.getClass()) && (JsonPointer.class.isAssignableFrom(charSequence.getClass()) || 0 == charSequence.length() || '/' == charSequence.charAt(0));
    }
}

