/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.SerializationContext;

public interface JsonField {
    public static JsonField newInstance(CharSequence key, @Nullable JsonValue value) {
        return JsonFactory.newField(JsonFactory.newKey(key), value);
    }

    public static JsonField newInstance(CharSequence key, @Nullable JsonValue value, @Nullable JsonFieldDefinition definition) {
        return JsonFactory.newField(JsonFactory.newKey(key), value, definition);
    }

    public static Predicate<JsonField> isValueNonNull() {
        return jsonField -> !jsonField.getValue().isNull();
    }

    public String getKeyName();

    public JsonKey getKey();

    public JsonValue getValue();

    public Optional<JsonFieldDefinition> getDefinition();

    public boolean isMarkedAs(JsonFieldMarker var1, JsonFieldMarker ... var2);

    public void writeKeyAndValue(SerializationContext var1) throws IOException;
}

