/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;

public interface JsonFieldDefinition<T> {
    public static JsonFieldDefinition<String> ofString(CharSequence pointer, JsonFieldMarker ... markers) {
        return JsonFactory.newStringFieldDefinition(pointer, markers);
    }

    public static JsonFieldDefinition<Integer> ofInt(CharSequence pointer, JsonFieldMarker ... markers) {
        return JsonFactory.newIntFieldDefinition(pointer, markers);
    }

    public static JsonFieldDefinition<Long> ofLong(CharSequence pointer, JsonFieldMarker ... markers) {
        return JsonFactory.newLongFieldDefinition(pointer, markers);
    }

    public static JsonFieldDefinition<Double> ofDouble(CharSequence pointer, JsonFieldMarker ... markers) {
        return JsonFactory.newDoubleFieldDefinition(pointer, markers);
    }

    public static JsonFieldDefinition<Boolean> ofBoolean(CharSequence pointer, JsonFieldMarker ... markers) {
        return JsonFactory.newBooleanFieldDefinition(pointer, markers);
    }

    public static JsonFieldDefinition<JsonObject> ofJsonObject(CharSequence pointer, JsonFieldMarker ... markers) {
        return JsonFactory.newJsonObjectFieldDefinition(pointer, markers);
    }

    public static JsonFieldDefinition<JsonArray> ofJsonArray(CharSequence pointer, JsonFieldMarker ... markers) {
        return JsonFactory.newJsonArrayFieldDefinition(pointer, markers);
    }

    public static JsonFieldDefinition<JsonValue> ofJsonValue(CharSequence pointer, JsonFieldMarker ... markers) {
        return JsonFactory.newJsonValueFieldDefinition(pointer, markers);
    }

    public JsonPointer getPointer();

    public Class<T> getValueType();

    public Set<JsonFieldMarker> getMarkers();

    public boolean isMarkedAs(JsonFieldMarker var1, JsonFieldMarker ... var2);

    @Nullable
    public T mapValue(JsonValue var1);
}

