/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.AbstractJsonExceptionBuilder;
import org.eclipse.ditto.json.JsonRuntimeException;

public final class JsonFieldSelectorInvalidException
extends JsonRuntimeException {
    public static final String ERROR_CODE = "json.fieldselector.invalid";
    private static final String DEFAULT_DESCRIPTION = "Check, for example, if the amount of opening parentheses '(' matches the amount of closing ones ')'.";
    private static final long serialVersionUID = -8483368816839385508L;

    private JsonFieldSelectorInvalidException(@Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, message, description, cause, href);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder
    extends AbstractJsonExceptionBuilder<JsonFieldSelectorInvalidException> {
        private Builder() {
            super(JsonFieldSelectorInvalidException.ERROR_CODE);
            this.description(JsonFieldSelectorInvalidException.DEFAULT_DESCRIPTION);
        }

        public Builder fieldSelector(String fieldSelector) {
            this.message(MessageFormat.format("The field selector <{0}> is invalid!", fieldSelector));
            return this;
        }

        @Override
        protected JsonFieldSelectorInvalidException doBuild(String errorCode, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new JsonFieldSelectorInvalidException(message, description, cause, href);
        }
    }
}

