/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonPointer;

@NotThreadSafe
final class JsonFieldSelectorTrie {
    private final Map<JsonKey, JsonFieldSelectorTrie> children = new LinkedHashMap<JsonKey, JsonFieldSelectorTrie>();

    private JsonFieldSelectorTrie() {
    }

    static JsonFieldSelectorTrie of(Iterable<JsonPointer> jsonPointers) {
        Objects.requireNonNull(jsonPointers, "The JSON pointers must not be null!");
        JsonFieldSelectorTrie trie = new JsonFieldSelectorTrie();
        jsonPointers.forEach(trie::add);
        return trie;
    }

    JsonFieldSelectorTrie add(JsonPointer jsonPointer) {
        Objects.requireNonNull(jsonPointer, "The JSON pointer to be added must not be null!");
        return this.addJsonKeyIterator(jsonPointer.iterator());
    }

    private JsonFieldSelectorTrie addJsonKeyIterator(Iterator<JsonKey> iterator) {
        if (iterator.hasNext()) {
            JsonKey key = iterator.next();
            this.children.compute(key, (theKey, theChild) -> {
                JsonFieldSelectorTrie child = theChild != null ? theChild : new JsonFieldSelectorTrie();
                return child.addJsonKeyIterator(iterator);
            });
        }
        return this;
    }

    boolean isEmpty() {
        return this.children.isEmpty();
    }

    Set<JsonKey> getKeys() {
        return this.children.keySet();
    }

    JsonFieldSelectorTrie descend(JsonKey key) {
        JsonFieldSelectorTrie child = this.children.get(key);
        return child != null ? child : new JsonFieldSelectorTrie();
    }
}

