/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.AbstractJsonExceptionBuilder;
import org.eclipse.ditto.json.JsonExceptionBuilder;
import org.eclipse.ditto.json.JsonRuntimeException;

public final class JsonKeyInvalidException
extends JsonRuntimeException {
    public static final String ERROR_CODE = "json.key.invalid";
    private static final String DEFAULT_DESCRIPTION = "Neither slashes nor any control characters are allowed as part of the JSON key.";
    private static final long serialVersionUID = -3123581233292259932L;

    private JsonKeyInvalidException(@Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, message, description, cause, href);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static JsonExceptionBuilder<JsonKeyInvalidException> newBuilderWithDescription(CharSequence jsonKey, @Nullable String description) {
        return new Builder().jsonPointer(jsonKey).description(description);
    }

    public static JsonExceptionBuilder<JsonKeyInvalidException> newBuilderWithoutDescription(CharSequence jsonKey) {
        return new Builder().jsonPointer(jsonKey).description(DEFAULT_DESCRIPTION);
    }

    @NotThreadSafe
    public static final class Builder
    extends AbstractJsonExceptionBuilder<JsonKeyInvalidException> {
        private Builder() {
            super(JsonKeyInvalidException.ERROR_CODE);
            this.description(JsonKeyInvalidException.DEFAULT_DESCRIPTION);
        }

        public Builder jsonPointer(@Nullable CharSequence jsonKeyString) {
            this.message(MessageFormat.format("The JSON key <{0}> is invalid!", jsonKeyString));
            return this;
        }

        @Override
        protected JsonKeyInvalidException doBuild(String errorCode, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new JsonKeyInvalidException(message, description, cause, href);
        }
    }
}

