/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.AbstractJsonExceptionBuilder;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonRuntimeException;

public final class JsonMissingFieldException
extends JsonRuntimeException {
    public static final String ERROR_CODE = "json.field.missing";
    private static final String MESSAGE_TEMPLATE = "JSON did not include required <{0}> field!";
    private static final String DEFAULT_DESCRIPTION = "Check if all required JSON fields were set.";
    private static final long serialVersionUID = -2569054723339845869L;

    private JsonMissingFieldException(@Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, message, description, cause, href);
    }

    public JsonMissingFieldException(CharSequence key) {
        this(MessageFormat.format(MESSAGE_TEMPLATE, key), DEFAULT_DESCRIPTION, null, null);
    }

    public JsonMissingFieldException(JsonFieldDefinition<?> fieldDefinition) {
        this(Objects.requireNonNull(fieldDefinition, "The JSON Field Definition must not be null!").getPointer());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder
    extends AbstractJsonExceptionBuilder<JsonMissingFieldException> {
        private Builder() {
            super(JsonMissingFieldException.ERROR_CODE);
            this.description(JsonMissingFieldException.DEFAULT_DESCRIPTION);
        }

        public Builder fieldName(CharSequence missingFieldName) {
            this.message(MessageFormat.format(JsonMissingFieldException.MESSAGE_TEMPLATE, missingFieldName));
            return this;
        }

        public Builder fieldName(CharSequence missingFieldNameRoot, CharSequence ... missingFieldNameChildren) {
            Objects.requireNonNull(missingFieldNameRoot, "The root of the field name hierarchy must not be null!");
            Objects.requireNonNull(missingFieldNameChildren, "The field name children must not be null!");
            ArrayList<CharSequence> allFieldNames = new ArrayList<CharSequence>(1 + missingFieldNameChildren.length);
            allFieldNames.add(missingFieldNameRoot);
            Collections.addAll(allFieldNames, missingFieldNameChildren);
            return this.fieldName(String.join((CharSequence)".", allFieldNames));
        }

        @Override
        protected JsonMissingFieldException doBuild(String errorCode, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new JsonMissingFieldException(message, description, cause, href);
        }
    }
}

