/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.JsonValueContainer;

public interface JsonObject
extends JsonValue,
JsonValueContainer<JsonField> {
    public static JsonObject of(String jsonObjectString) {
        return JsonFactory.newObject(jsonObjectString);
    }

    public static JsonObject of(byte[] jsonData) {
        return JsonFactory.newObject(jsonData);
    }

    public static JsonObjectBuilder newBuilder() {
        return JsonFactory.newObjectBuilder();
    }

    public static JsonObject empty() {
        return JsonFactory.newObject();
    }

    default public JsonObjectBuilder toBuilder() {
        return JsonFactory.newObjectBuilder(this);
    }

    public JsonObject setValue(CharSequence var1, int var2);

    public JsonObject setValue(CharSequence var1, long var2);

    public JsonObject setValue(CharSequence var1, double var2);

    public JsonObject setValue(CharSequence var1, boolean var2);

    public JsonObject setValue(CharSequence var1, String var2);

    public JsonObject setValue(CharSequence var1, JsonValue var2);

    public <T> JsonObject set(JsonFieldDefinition<T> var1, @Nullable T var2);

    public JsonObject set(JsonField var1);

    public JsonObject setAll(Iterable<JsonField> var1);

    public boolean contains(CharSequence var1);

    public JsonObject get(JsonPointer var1);

    public JsonObject get(JsonFieldDefinition var1);

    public JsonObject get(JsonFieldSelector var1);

    public Optional<JsonValue> getValue(CharSequence var1);

    public <T> Optional<T> getValue(JsonFieldDefinition<T> var1);

    public <T> T getValueOrThrow(JsonFieldDefinition<T> var1);

    public JsonObject remove(CharSequence var1);

    public List<JsonKey> getKeys();

    public Optional<JsonField> getField(CharSequence var1);
}

