/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.text.MessageFormat;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.AbstractJsonMerger;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonArrayBuilder;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class JsonObjectMerger
extends AbstractJsonMerger {
    JsonObjectMerger() {
    }

    public static JsonObject mergeJsonObjects(JsonObject jsonObject1, JsonObject jsonObject2) {
        JsonObjectBuilder builder = JsonFactory.newObjectBuilder();
        if (jsonObject1.isNull() && jsonObject2.isNull()) {
            return JsonFactory.nullObject();
        }
        jsonObject1.forEach(jsonField -> {
            JsonKey key = jsonField.getKey();
            JsonValue value1 = jsonField.getValue();
            Optional<JsonValue> maybeValue2 = jsonObject2.getValue(key);
            if (maybeValue2.isPresent()) {
                builder.set((CharSequence)key, JsonObjectMerger.mergeJsonValues(value1, maybeValue2.get()));
            } else {
                builder.set((JsonField)jsonField);
            }
        });
        jsonObject2.forEach(jsonField -> {
            if (!jsonObject1.contains(jsonField.getKey())) {
                builder.set((JsonField)jsonField);
            }
        });
        return builder.build();
    }

    private static JsonValue mergeJsonValues(JsonValue value1, JsonValue value2) {
        JsonValue result = JsonObjectMerger.areJsonObjects(value1, value2) ? JsonObjectMerger.mergeJsonObjects(value1.asObject(), value2.asObject()) : (JsonObjectMerger.areJsonArrays(value1, value2) ? JsonObjectMerger.mergeJsonArrays(value1.asArray(), value2.asArray()) : value1);
        return result;
    }

    private static JsonArray mergeJsonArrays(JsonArray array1, JsonArray array2) {
        int i;
        JsonArray longerArray = array1.getSize() >= array2.getSize() ? array1 : array2;
        int longerSize = longerArray.getSize();
        int shorterSize = Math.min(array1.getSize(), array2.getSize());
        JsonArrayBuilder builder = JsonFactory.newArrayBuilder();
        for (i = 0; i < shorterSize; ++i) {
            builder.add(JsonObjectMerger.mergeJsonValues(JsonObjectMerger.getOrThrow(array1, i), JsonObjectMerger.getOrThrow(array2, i)), new JsonValue[0]);
        }
        for (i = shorterSize; i < longerSize; ++i) {
            builder.add(JsonObjectMerger.getOrThrow(longerArray, i), new JsonValue[0]);
        }
        return builder.build();
    }

    private static JsonValue getOrThrow(JsonArray jsonArray, int index) {
        return jsonArray.get(index).orElseThrow(() -> {
            String msgPattern = "JsonArray did not contain a value for index <{0}>!";
            return new NullPointerException(MessageFormat.format("JsonArray did not contain a value for index <{0}>!", index));
        });
    }
}

