/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.AbstractJsonExceptionBuilder;
import org.eclipse.ditto.json.JsonRuntimeException;

public final class JsonParseException
extends JsonRuntimeException {
    public static final String ERROR_CODE = "json.invalid";
    private static final String DEFAULT_DESCRIPTION = "Check if the JSON was valid (e.g. on https://jsonlint.com) and if it was in required format.";
    private static final long serialVersionUID = -7585793723086474449L;

    private JsonParseException(@Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, message, description, cause, href);
    }

    public JsonParseException(@Nullable String message) {
        this(message, DEFAULT_DESCRIPTION, null, null);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder
    extends AbstractJsonExceptionBuilder<JsonParseException> {
        private Builder() {
            super(JsonParseException.ERROR_CODE);
            this.description(JsonParseException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected JsonParseException doBuild(String errorCode, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new JsonParseException(message, description, cause, href);
        }
    }
}

