/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;

public interface JsonPatch {
    public static JsonPatch newInstance(Operation operation, JsonPointer path, JsonValue value) {
        return JsonFactory.newPatch(operation, path, value);
    }

    public Operation getOperation();

    public JsonPointer getPath();

    public Optional<JsonValue> getValue();

    public JsonObject toJson();

    public String toString();

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<String> OPERATION = JsonFactory.newStringFieldDefinition("op", new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<String> PATH = JsonFactory.newStringFieldDefinition("path", new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<JsonValue> VALUE = JsonFactory.newJsonValueFieldDefinition("value", new JsonFieldMarker[0]);

        private JsonFields() {
            throw new AssertionError();
        }
    }

    public static enum Operation {
        ADD("add"),
        REMOVE("remove"),
        REPLACE("replace");

        private final String name;

        private Operation(String name) {
            this.name = name;
        }

        public static Optional<Operation> fromString(@Nullable String name) {
            return Stream.of(Operation.values()).filter(operation -> Objects.equals(operation.name, name)).findAny();
        }

        public String toString() {
            return this.name;
        }
    }
}

