/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.AbstractJsonExceptionBuilder;
import org.eclipse.ditto.json.JsonExceptionBuilder;
import org.eclipse.ditto.json.JsonRuntimeException;

public final class JsonPointerInvalidException
extends JsonRuntimeException {
    public static final String ERROR_CODE = "json.pointer.invalid";
    private static final String DEFAULT_DESCRIPTION = "Check, for example, if the JSON Pointer is not empty.";
    private static final String MULTIPLE_SLASHES_DESCRIPTION = "Consecutive slashes in JSON pointers are not supported.";
    private static final String OUTER_SLASHES_DESCRIPTION = "Leading or trailing slashes in JSON pointers are not supported.";
    private static final long serialVersionUID = -6773700329225961931L;

    private JsonPointerInvalidException(@Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, message, description, cause, href);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static JsonExceptionBuilder<JsonPointerInvalidException> newBuilderForConsecutiveSlashes(CharSequence jsonPointer) {
        return new Builder().jsonPointer(jsonPointer).description(MULTIPLE_SLASHES_DESCRIPTION);
    }

    public static JsonExceptionBuilder<JsonPointerInvalidException> newBuilderForOuterSlashes(CharSequence jsonPointer) {
        return new Builder().jsonPointer(jsonPointer).description(OUTER_SLASHES_DESCRIPTION);
    }

    @NotThreadSafe
    public static final class Builder
    extends AbstractJsonExceptionBuilder<JsonPointerInvalidException> {
        private Builder() {
            super(JsonPointerInvalidException.ERROR_CODE);
            this.description(JsonPointerInvalidException.DEFAULT_DESCRIPTION);
        }

        public Builder jsonPointer(@Nullable CharSequence jsonPointerString) {
            this.message(MessageFormat.format("The JSON pointer <{0}> is invalid!", jsonPointerString));
            return this;
        }

        @Override
        protected JsonPointerInvalidException doBuild(String errorCode, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new JsonPointerInvalidException(message, description, cause, href);
        }
    }
}

