/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.AbstractJsonExceptionBuilder;
import org.eclipse.ditto.json.JsonException;
import org.eclipse.ditto.json.JsonExceptionBuilder;

public class JsonRuntimeException
extends RuntimeException
implements JsonException {
    private static final long serialVersionUID = -5415257195206366631L;
    private final String errorCode;
    @Nullable
    private final String description;
    @Nullable
    private final URI href;

    protected JsonRuntimeException(String errorCode, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(message, cause);
        JsonRuntimeException.checkErrorCode(errorCode);
        this.errorCode = errorCode;
        this.description = description;
        this.href = href;
    }

    public static JsonExceptionBuilder newBuilder(String errorCode) {
        JsonRuntimeException.checkErrorCode(errorCode);
        return new Builder(errorCode);
    }

    private static void checkErrorCode(String errorCode) {
        String msgTemplate = "The error code of this exception must not be {0}!";
        Objects.requireNonNull(errorCode, MessageFormat.format("The error code of this exception must not be {0}!", "null"));
        if (errorCode.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("The error code of this exception must not be {0}!", "empty"));
        }
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public Optional<URI> getHref() {
        return Optional.ofNullable(this.href);
    }

    @NotThreadSafe
    public static final class Builder
    extends AbstractJsonExceptionBuilder<JsonRuntimeException> {
        private Builder(String errorCode) {
            super(errorCode);
        }

        @Override
        protected JsonRuntimeException doBuild(String errorCode, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new JsonRuntimeException(errorCode, message, description, cause, href);
        }
    }
}

