/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.io.IOException;
import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.SerializationContext;

public interface JsonValue {
    public static JsonValue nullLiteral() {
        return JsonFactory.nullLiteral();
    }

    public static JsonValue of(boolean value) {
        return JsonFactory.newValue(value);
    }

    public static JsonValue of(int value) {
        return JsonFactory.newValue(value);
    }

    public static JsonValue of(long value) {
        return JsonFactory.newValue(value);
    }

    public static JsonValue of(double value) {
        return JsonFactory.newValue(value);
    }

    public static JsonValue of(@Nullable String jsonString) {
        return JsonFactory.newValue(jsonString);
    }

    public static <T> JsonValue of(@Nullable T value) {
        return JsonFactory.getAppropriateValue(value);
    }

    public boolean isBoolean();

    public boolean isNumber();

    public boolean isInt();

    public boolean isLong();

    public boolean isDouble();

    public boolean isString();

    public boolean isObject();

    public boolean isArray();

    public boolean isNull();

    public boolean asBoolean();

    public int asInt();

    public long asLong();

    public double asDouble();

    public String asString();

    public JsonObject asObject();

    public JsonArray asArray();

    public String toString();

    default public String formatAsString() {
        return this.isString() ? this.asString() : this.toString();
    }

    public void writeValue(SerializationContext var1) throws IOException;

    public long getUpperBoundForStringSize();
}

