/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.AbstractJsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class JsonValueFieldDefinition<T extends JsonValue>
extends AbstractJsonFieldDefinition<T> {
    private JsonValueFieldDefinition(CharSequence pointer, Class<T> valueType, Function<JsonValue, Boolean> checkJavaTypeFunction, Function<JsonValue, T> mappingFunction, JsonFieldMarker ... markers) {
        super(pointer, valueType, checkJavaTypeFunction, mappingFunction, markers);
    }

    public static <T extends JsonValue> JsonValueFieldDefinition<T> newInstance(CharSequence pointer, Class<T> valueType, Function<JsonValue, Boolean> checkJavaTypeFunction, Function<JsonValue, T> mappingFunction, JsonFieldMarker ... markers) {
        Objects.requireNonNull(mappingFunction, "The mapping function must not be null!");
        return new JsonValueFieldDefinition<T>(pointer, valueType, checkJavaTypeFunction, mappingFunction, markers);
    }

    @Override
    protected T getAsJavaType(JsonValue jsonValue, Function<JsonValue, T> mappingFunction) {
        return (T)((JsonValue)mappingFunction.apply(jsonValue));
    }
}

