/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.AbstractJsonMerger;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class JsonValueMerger
extends AbstractJsonMerger {
    JsonValueMerger() {
    }

    public static JsonValue mergeJsonValues(JsonValue value1, JsonValue value2) {
        JsonValue result = JsonValueMerger.areJsonObjects(value1, value2) ? JsonValueMerger.mergeJsonObjects(value1.asObject(), value2.asObject()) : (JsonValueMerger.areJsonArrays(value1, value2) ? value1.asArray() : (value1.isObject() ? JsonValueMerger.filterNullValues(value1.asObject()) : value1));
        return result;
    }

    private static JsonObject mergeJsonObjects(JsonObject jsonObject1, JsonObject jsonObject2) {
        if (jsonObject1.isNull() || jsonObject1.isNull() && jsonObject2.isNull()) {
            return JsonFactory.nullObject();
        }
        JsonObjectBuilder builder = JsonFactory.newObjectBuilder();
        jsonObject1.forEach(jsonField -> {
            JsonKey key = jsonField.getKey();
            JsonValue value1 = jsonField.getValue();
            Optional<JsonValue> maybeValue2 = jsonObject2.getValue(key);
            if (value1.isNull()) {
                return;
            }
            if (maybeValue2.isPresent()) {
                builder.set((CharSequence)key, JsonValueMerger.mergeJsonValues(value1, maybeValue2.get()));
            } else if (value1.isObject()) {
                builder.set((CharSequence)key, JsonValueMerger.filterNullValues(value1.asObject()));
            } else {
                builder.set((JsonField)jsonField);
            }
        });
        jsonObject2.forEach(jsonField -> {
            if (!jsonObject1.contains(jsonField.getKey())) {
                builder.set((JsonField)jsonField);
            }
        });
        return builder.build();
    }
}

