/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import com.eclipsesource.json.JsonHandler;
import com.eclipsesource.json.JsonParser;
import com.eclipsesource.json.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.DefaultDittoJsonHandler;
import org.eclipse.ditto.json.DittoJsonHandler;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class JsonValueParser {
    @Nullable
    private static Function<String, JsonValue> fromStringInstance = null;

    private JsonValueParser() {
    }

    public static <A, O, V> Consumer<String> fromString(DittoJsonHandler<A, O, V> jsonHandler) {
        return jsonString -> JsonValueParser.tryToParseJsonValue(jsonString, jsonHandler);
    }

    public static Function<String, JsonValue> fromString() {
        Function<String, JsonValue> result = fromStringInstance;
        if (null == result) {
            fromStringInstance = result = jsonString -> JsonValueParser.tryToParseJsonValue(jsonString, DefaultDittoJsonHandler.newInstance());
        }
        return result;
    }

    public static Function<Reader, JsonValue> fromReader() {
        return JsonValueParser::tryToReadJsonValueFrom;
    }

    private static <T> T tryToParseJsonValue(String jsonString, DittoJsonHandler<?, ?, T> dittoJsonHandler) {
        try {
            return JsonValueParser.parseJsonValue(jsonString, dittoJsonHandler);
        }
        catch (ParseException | IllegalArgumentException | NullPointerException | StackOverflowError | UnsupportedOperationException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Failed to parse JSON string ''{0}''!", jsonString)).cause(e).build();
        }
    }

    private static <T> T parseJsonValue(String jsonString, DittoJsonHandler<?, ?, T> dittoJsonHandler) {
        Objects.requireNonNull(jsonString, "The JSON string to be parsed must not be null!");
        new JsonParser(dittoJsonHandler).parse(jsonString);
        return dittoJsonHandler.getValue();
    }

    private static JsonValue tryToReadJsonValueFrom(Reader reader) {
        try {
            return JsonValueParser.readJsonValueFrom(reader);
        }
        catch (ParseException | IOException | IllegalArgumentException | NullPointerException | StackOverflowError e) {
            throw (JsonParseException)JsonParseException.newBuilder().message("Failed to parse JSON value from reader!").cause(e).build();
        }
    }

    private static JsonValue readJsonValueFrom(Reader reader) throws IOException {
        Objects.requireNonNull(reader, "The reader must not be null!");
        DefaultDittoJsonHandler dittoJsonHandler = DefaultDittoJsonHandler.newInstance();
        new JsonParser((JsonHandler)dittoJsonHandler).parse(reader);
        return dittoJsonHandler.getValue();
    }
}

