/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.acks;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.acks.AcknowledgementLabel;
import org.eclipse.ditto.model.base.acks.AcknowledgementRequest;
import org.eclipse.ditto.model.base.acks.DittoAcknowledgementLabel;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.DittoHeaderDefinition;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.DittoHeadersBuilder;
import org.eclipse.ditto.model.base.headers.WithDittoHeaders;

@Immutable
public abstract class AbstractCommandAckRequestSetter<C extends WithDittoHeaders<? extends C>>
implements UnaryOperator<C> {
    private static final String LIVE_CHANNEL = "live";
    private final AcknowledgementLabel implicitAcknowledgementLabel;
    private final Set<AcknowledgementLabel> negatedDittoAcknowledgementLabels;

    protected AbstractCommandAckRequestSetter(AcknowledgementLabel implicitAcknowledgementLabel) {
        this(implicitAcknowledgementLabel, Collections.unmodifiableSet(Arrays.stream(DittoAcknowledgementLabel.values()).filter(v -> !implicitAcknowledgementLabel.equals(v)).collect(Collectors.toSet())));
    }

    protected AbstractCommandAckRequestSetter(AcknowledgementLabel implicitAcknowledgementLabel, Set<AcknowledgementLabel> negatedDittoAcknowledgementLabels) {
        this.implicitAcknowledgementLabel = implicitAcknowledgementLabel;
        this.negatedDittoAcknowledgementLabels = negatedDittoAcknowledgementLabels;
    }

    @Override
    public C apply(C command) {
        ConditionChecker.checkNotNull(command, "command");
        if (this.isApplicable(command)) {
            return (C)this.setDefaultDittoHeaders(command.getDittoHeaders()).map(arg_0 -> command.setDittoHeaders(arg_0)).orElse((WithDittoHeaders)command);
        }
        return command;
    }

    public abstract boolean isApplicable(C var1);

    public abstract Class<C> getMatchedClass();

    protected boolean isLiveChannelCommand(C command) {
        return command.getDittoHeaders().getChannel().filter(LIVE_CHANNEL::equals).isPresent();
    }

    protected abstract boolean isBindResponseRequiredToAddingRemovingImplicitLabel();

    private Optional<DittoHeaders> setDefaultDittoHeaders(DittoHeaders headers) {
        DittoHeadersBuilder builder = headers.toBuilder();
        Set<AcknowledgementRequest> requestedAcks = headers.getAcknowledgementRequests();
        boolean hasTimeoutZero = headers.getTimeout().filter(Duration::isZero).isPresent();
        boolean implicitAcksRequested = this.implicitAcksRequested(builder, headers, hasTimeoutZero);
        boolean explicitRequestedAcksFiltered = this.explicitRequestedAcksFiltered(builder, requestedAcks);
        boolean responseRequiredSet = this.responseRequiredSet(headers, builder, hasTimeoutZero);
        if (implicitAcksRequested || explicitRequestedAcksFiltered || responseRequiredSet) {
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    private boolean implicitAcksRequested(DittoHeadersBuilder<?, ?> builder, DittoHeaders headers, boolean hasTimeoutZero) {
        boolean isResponseRequired = headers.isResponseRequired();
        if (headers.containsKey(DittoHeaderDefinition.REQUESTED_ACKS.getKey())) {
            if (this.isBindResponseRequiredToAddingRemovingImplicitLabel()) {
                Set<AcknowledgementRequest> acknowledgementRequests = headers.getAcknowledgementRequests();
                LinkedHashSet<AcknowledgementRequest> newRequests = new LinkedHashSet<AcknowledgementRequest>(acknowledgementRequests);
                if (isResponseRequired && !acknowledgementRequests.isEmpty()) {
                    newRequests.add(AcknowledgementRequest.of(this.implicitAcknowledgementLabel));
                } else if (!isResponseRequired) {
                    newRequests.remove(AcknowledgementRequest.of(this.implicitAcknowledgementLabel));
                }
                builder.acknowledgementRequests(newRequests);
                return true;
            }
            return false;
        }
        if (!hasTimeoutZero && isResponseRequired) {
            builder.acknowledgementRequest(AcknowledgementRequest.of(this.implicitAcknowledgementLabel), new AcknowledgementRequest[0]);
        } else {
            builder.acknowledgementRequests(Collections.emptySet());
        }
        return true;
    }

    private boolean explicitRequestedAcksFiltered(DittoHeadersBuilder<?, ?> builder, Set<AcknowledgementRequest> requestedAcks) {
        if (!requestedAcks.isEmpty()) {
            boolean isFiltered;
            Set filteredAckRequests = requestedAcks.stream().filter(request -> !this.negatedDittoAcknowledgementLabels.contains(request.getLabel())).collect(Collectors.toCollection(LinkedHashSet::new));
            boolean bl = isFiltered = filteredAckRequests.size() != requestedAcks.size();
            if (isFiltered) {
                builder.acknowledgementRequests(filteredAckRequests);
            }
            return isFiltered;
        }
        return false;
    }

    private boolean responseRequiredSet(DittoHeaders dittoHeaders, DittoHeadersBuilder<?, ?> builder, boolean hasTimeoutZero) {
        if (!dittoHeaders.containsKey(DittoHeaderDefinition.RESPONSE_REQUIRED.getKey())) {
            boolean isResponseRequired = !hasTimeoutZero;
            builder.responseRequired(isResponseRequired);
            return true;
        }
        return false;
    }
}

