/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.acks;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.acks.AcknowledgementException;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="acknowledgement:label.invalid")
@Immutable
public final class AcknowledgementLabelInvalidException
extends DittoRuntimeException
implements AcknowledgementException {
    public static final String ERROR_CODE = "acknowledgement:label.invalid";
    private static final String MESSAGE_TEMPLATE = "Acknowledgement label <{0}> is invalid.";
    private static final String DEFAULT_DESCRIPTION = "An acknowledgement label must conform to the regular expression of Ditto documentation.";
    private static final URI DEFAULT_HREF = URI.create("https://www.eclipse.org/ditto/protocol-specification-topic.html#acknowledgement-criterion-actions");
    private static final long serialVersionUID = -2385649293006205966L;

    private AcknowledgementLabelInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public AcknowledgementLabelInvalidException(CharSequence label) {
        this(DittoHeaders.empty(), MessageFormat.format(MESSAGE_TEMPLATE, label), DEFAULT_DESCRIPTION, null, DEFAULT_HREF);
    }

    public static AcknowledgementLabelInvalidException of(CharSequence label, @Nullable String description, @Nullable URI href, DittoHeaders dittoHeaders) {
        return new AcknowledgementLabelInvalidException(dittoHeaders, MessageFormat.format(MESSAGE_TEMPLATE, label), description, null, href);
    }

    public static AcknowledgementLabelInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    private static class Builder
    extends DittoRuntimeExceptionBuilder<AcknowledgementLabelInvalidException> {
        private Builder() {
            this.description(AcknowledgementLabelInvalidException.DEFAULT_DESCRIPTION);
            this.href(DEFAULT_HREF);
        }

        @Override
        protected AcknowledgementLabelInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new AcknowledgementLabelInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

