/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.acks;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.acks.AcknowledgementException;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="acknowledgement:label.not.declared")
@Immutable
public final class AcknowledgementLabelNotDeclaredException
extends DittoRuntimeException
implements AcknowledgementException {
    public static final String ERROR_CODE = "acknowledgement:label.not.declared";
    private static final String MESSAGE_TEMPLATE = "Cannot send acknowledgement with label <{0}>, which is not declared.";
    private static final String DEFAULT_DESCRIPTION = "Each connection may only send acknowledgements whose label matches one declared for the connection.";

    private AcknowledgementLabelNotDeclaredException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static AcknowledgementLabelNotDeclaredException of(CharSequence label, DittoHeaders dittoHeaders) {
        return new AcknowledgementLabelNotDeclaredException(dittoHeaders, MessageFormat.format(MESSAGE_TEMPLATE, label), DEFAULT_DESCRIPTION, null, null);
    }

    public static AcknowledgementLabelNotDeclaredException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return new AcknowledgementLabelNotDeclaredException(dittoHeaders, AcknowledgementLabelNotDeclaredException.readMessage(jsonObject), AcknowledgementLabelNotDeclaredException.readDescription(jsonObject).orElse(DEFAULT_DESCRIPTION), null, AcknowledgementLabelNotDeclaredException.readHRef(jsonObject).orElse(null));
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<AcknowledgementLabelNotDeclaredException> {
        private Builder() {
            this.description(AcknowledgementLabelNotDeclaredException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected AcknowledgementLabelNotDeclaredException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new AcknowledgementLabelNotDeclaredException(dittoHeaders, message, description, cause, href);
        }
    }
}

