/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.acks;

import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.acks.AcknowledgementException;
import org.eclipse.ditto.model.base.acks.FatalPubSubException;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="acknowledgement:label.not.unique")
@Immutable
public final class AcknowledgementLabelNotUniqueException
extends DittoRuntimeException
implements AcknowledgementException,
FatalPubSubException {
    public static final String ERROR_CODE = "acknowledgement:label.not.unique";
    private static final String DEFAULT_MESSAGE = "One or more declared acknowledgement labels are taken by other subscribers.";
    private static final String DEFAULT_DESCRIPTION = "Please ensure all other subscribers with the declared acknowledgement labels are offline.";
    private static final AcknowledgementLabelNotUniqueException INSTANCE = (AcknowledgementLabelNotUniqueException)AcknowledgementLabelNotUniqueException.newBuilder().build();

    private AcknowledgementLabelNotUniqueException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.CONFLICT, dittoHeaders, message, description, cause, href);
    }

    public static AcknowledgementLabelNotUniqueException getInstance() {
        return INSTANCE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static AcknowledgementLabelNotUniqueException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @Override
    public DittoRuntimeException asDittoRuntimeException() {
        return this;
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<AcknowledgementLabelNotUniqueException> {
        private Builder() {
            this.message(AcknowledgementLabelNotUniqueException.DEFAULT_MESSAGE);
            this.description(AcknowledgementLabelNotUniqueException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected AcknowledgementLabelNotUniqueException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new AcknowledgementLabelNotUniqueException(dittoHeaders, message, description, cause, href);
        }
    }
}

