/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.acks;

import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.acks.AcknowledgementLabel;
import org.eclipse.ditto.model.base.acks.AcknowledgementLabelInvalidException;
import org.eclipse.ditto.model.base.acks.AcknowledgementRequest;
import org.eclipse.ditto.model.base.acks.AcknowledgementRequestParseException;
import org.eclipse.ditto.model.base.acks.FilteredAcknowledgementRequest;
import org.eclipse.ditto.model.base.acks.ImmutableAcknowledgementRequest;
import org.eclipse.ditto.model.base.acks.ImmutableFilteredAcknowledgementRequest;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.DittoHeaders;

@Immutable
final class AcknowledgementRequests {
    private AcknowledgementRequests() {
        throw new AssertionError();
    }

    public static ImmutableAcknowledgementRequest newAcknowledgementRequest(AcknowledgementLabel acknowledgementLabel) {
        return ImmutableAcknowledgementRequest.getInstance(acknowledgementLabel);
    }

    public static ImmutableFilteredAcknowledgementRequest newFilteredAcknowledgementRequest(Set<AcknowledgementRequest> includes, @Nullable String filter) {
        return ImmutableFilteredAcknowledgementRequest.getInstance(includes, filter);
    }

    public static FilteredAcknowledgementRequest filteredAcknowledgementRequestFromJson(JsonObject jsonObject) {
        return ImmutableFilteredAcknowledgementRequest.fromJson(jsonObject);
    }

    public static ImmutableAcknowledgementRequest parseAcknowledgementRequest(CharSequence ackRequestRepresentation) {
        ConditionChecker.checkNotNull(ackRequestRepresentation, "ackRequestRepresentation");
        return AcknowledgementRequests.newAcknowledgementRequest(AcknowledgementRequests.tryToParseAcknowledgementLabel(ackRequestRepresentation));
    }

    private static AcknowledgementLabel tryToParseAcknowledgementLabel(CharSequence cs) {
        try {
            return AcknowledgementLabel.of(cs);
        }
        catch (AcknowledgementLabelInvalidException e) {
            throw new AcknowledgementRequestParseException(cs, e, DittoHeaders.empty());
        }
    }
}

