/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.acks;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.acks.AcknowledgementException;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="acknowledgement:ditto.acklabel.forbidden")
@Immutable
public final class DittoAcknowledgementLabelExternalUseForbiddenException
extends DittoRuntimeException
implements AcknowledgementException {
    public static final String ERROR_CODE = "acknowledgement:ditto.acklabel.forbidden";
    private static final String MESSAGE_TEMPLATE = "The Ditto internal Acknowledgement label <{0}> is not allowed to be issued externally!";
    private static final String DEFAULT_DESCRIPTION = "Make sure to not issue an Ditto internal Acknowledgement label.";
    private static final long serialVersionUID = 7892643278643243248L;

    private DittoAcknowledgementLabelExternalUseForbiddenException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public DittoAcknowledgementLabelExternalUseForbiddenException(CharSequence label) {
        this(DittoHeaders.empty(), MessageFormat.format(MESSAGE_TEMPLATE, label), DEFAULT_DESCRIPTION, null, null);
    }

    public static DittoAcknowledgementLabelExternalUseForbiddenException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return new DittoAcknowledgementLabelExternalUseForbiddenException(dittoHeaders, DittoAcknowledgementLabelExternalUseForbiddenException.readMessage(jsonObject), DittoAcknowledgementLabelExternalUseForbiddenException.readDescription(jsonObject).orElse(DEFAULT_DESCRIPTION), null, null);
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<DittoAcknowledgementLabelExternalUseForbiddenException> {
        private Builder() {
            this.description(DittoAcknowledgementLabelExternalUseForbiddenException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected DittoAcknowledgementLabelExternalUseForbiddenException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new DittoAcknowledgementLabelExternalUseForbiddenException(dittoHeaders, message, description, cause, href);
        }
    }
}

